﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Diagnostics;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // 中間ファイル最適化
    public abstract class IfOptimizer<TTarget>
    {
        // コンストラクタ
        public IfOptimizer(string toStringId)
        {
            this.ToStringId = toStringId;
        }

        // コンストラクタ
        public IfOptimizer(string toStringId, string argument)
        {
            this.ToStringId = toStringId;
            if (argument != null) { this.Argument = argument; }
        }

        // プロセス
        public abstract string Process { get; }

        // 結果の取得
        public abstract string GetResult();

        // 最適化
        public void Optimize(TTarget target,
            List<G3dStream> streams)
        {
            stopwatch.Reset();
            stopwatch.Start();

            this.Target = target;
            this.Streams = streams;

            Optimize();

            stopwatch.Stop();
        }

        // 最適化
        protected abstract void Optimize();

        // 文字列変換
        public override string ToString()
        {
            return IfStrings.Get(
                this.ToStringId,
                stopwatch.ElapsedMilliseconds);
        }

        public readonly string Argument = string.Empty;
        public TTarget Target { get; set; }
        public List<G3dStream> Streams { get; set; }
        public bool EnableProcessLog { get; set; }

        private readonly Stopwatch stopwatch = new Stopwatch();
        private readonly string ToStringId;
    }
}
