﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // ボーンビジビリティアニメーションの量子化分析
    public class IfBoneVisibilityAnimQuantizationAnalysisOptimizer
        : IfBoneVisibilityAnimOptimizer
    {
        // コンストラクタ
        public IfBoneVisibilityAnimQuantizationAnalysisOptimizer() :
            base("IfBoneVisibilityAnimQuantizationAnalysisOptimizer_Log") { }

        // プロセス
        public override string Process
        {
            get { return "quantization_analysis"; }
        }

        // 結果の取得
        public override string GetResult()
        {
            return string.Empty;
        }

        private int FrameSize;
        private int QuantizedFrameSize;

        // 最適化
        protected override void Optimize()
        {
            if (this.Target.bone_vis_bone_anim_array == null)
            {
                return;
            }

            bone_visibility_animType boneVisAnim = this.Target;
            bone_visibility_anim_infoType boneVisAnimInfo = boneVisAnim.bone_visibility_anim_info;
            IDictionary<bone_vis_bone_animType, IfAnimCurve> curveDic =
                new Dictionary<bone_vis_bone_animType, IfAnimCurve>();

            // カーブデータを構築する
            foreach (bone_vis_bone_animType visAnim in boneVisAnim.bone_vis_bone_anim_array.bone_vis_bone_anim)
            {
                if (visAnim.step_curve != null)
                {
                    IfAnimCurve animCurve = new IfAnimCurve();
                    animCurve.curveType = IfAnimCurve.CurveType.Bool;
                    animCurve.BuildIfAnimCurve(visAnim.step_curve, false, this.Streams);
                    curveDic.Add(visAnim, animCurve);
                }
            }

            // frame の量子化を評価して type を選択する。
            foreach (var curve in curveDic)
            {
                IfQuantizationAnalysisResult result =
                    IfBoneVisibilityAnimQuantizationAnalysis.Analyse(
                        boneVisAnimInfo,
                        curve.Value,
                        false);

                this.EnableProcessLog |= !result.skipped;

                ApplyQuantize(curve.Key, result);
            }
        }

        /// <summary>
        /// 量子化タイプを適応します。
        /// </summary>
        private void ApplyQuantize(bone_vis_bone_animType target, IfQuantizationAnalysisResult analysisResult)
        {
            curve_frame_typeType frameType = curve_frame_typeType.none;
            curve_key_typeType keyType = curve_key_typeType.none;
            int frameCount;

            step_curveType stepCurve = target.step_curve;
            stepCurve.frame_type = analysisResult.frameType;
            stepCurve.key_type = analysisResult.keyType;
            stepCurve.scale = analysisResult.scale;
            stepCurve.offset = analysisResult.offset;

            frameType = stepCurve.frame_type;
            keyType = stepCurve.key_type;
            frameCount = stepCurve.count;

            this.FrameSize += frameCount * sizeof(float);
            switch (frameType)
            {
                case curve_frame_typeType.none:
                case curve_frame_typeType.frame32:
                    this.QuantizedFrameSize += frameCount * sizeof(float);
                    break;
                case curve_frame_typeType.frame16:
                    this.QuantizedFrameSize += frameCount * sizeof(ushort);
                    break;
                case curve_frame_typeType.frame8:
                    this.QuantizedFrameSize += frameCount * sizeof(byte);
                    break;
            }
        }
    }
}
