﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // シーンアニメーションマージコンテキスト
    public class IfSceneAnimMergeContext
    {
        // コンストラクタ
        public IfSceneAnimMergeContext(
            scene_animType newSceneAnim,
            List<G3dStream> newStreams,
            scene_animType oldSceneAnim,
            List<G3dStream> oldStreams)
        {
            this.NewSceneAnim = newSceneAnim;
            this.NewStreams = newStreams;
            this.OldSceneAnim = oldSceneAnim;
            this.OldStreams = oldStreams;
        }

        // セットアップ
        public void Setup()
        {
            // <camera_anim> 名前一致でマージ
            if (this.NewSceneAnim.camera_anim_array != null &&
                this.NewSceneAnim.camera_anim_array.camera_anim != null &&
                this.OldSceneAnim.camera_anim_array != null &&
                this.OldSceneAnim.camera_anim_array.camera_anim != null)
            {
                IfMergeUtility.SetupTableByFunc<camera_animType>(this.CameraAnimTable,
                    this.OldSceneAnim.camera_anim_array.camera_anim,
                    this.NewSceneAnim.camera_anim_array.camera_anim,
                    delegate(camera_animType newObject, camera_animType oldObject)
                    {
                        return (newObject.camera_name == oldObject.camera_name);
                    });
            }

            // <light_anim> 名前一致でマージ
            if (this.NewSceneAnim.light_anim_array != null &&
                this.NewSceneAnim.light_anim_array.light_anim != null &&
                this.OldSceneAnim.light_anim_array != null &&
                this.OldSceneAnim.light_anim_array.light_anim != null)
            {
                IfMergeUtility.SetupTableByFunc<light_animType>(this.LightAnimTable,
                    this.OldSceneAnim.light_anim_array.light_anim,
                    this.NewSceneAnim.light_anim_array.light_anim,
                    delegate(light_animType newObject, light_animType oldObject)
                    {
                        return (newObject.light_name == oldObject.light_name);
                    });
            }

            // <fog_anim> 名前一致でマージ
            if (this.NewSceneAnim.fog_anim_array != null &&
                this.NewSceneAnim.fog_anim_array.fog_anim != null &&
                this.OldSceneAnim.fog_anim_array != null &&
                this.OldSceneAnim.fog_anim_array.fog_anim != null)
            {
                IfMergeUtility.SetupTableByFunc<fog_animType>(this.FogAnimTable,
                    this.OldSceneAnim.fog_anim_array.fog_anim,
                    this.NewSceneAnim.fog_anim_array.fog_anim,
                    delegate(fog_animType newObject, fog_animType oldObject)
                    {
                        return (newObject.fog_name == oldObject.fog_name);
                    });
            }
        }

        //=====================================================================
        // 再出力した新しいシーンアニメーション、マージ先
        public readonly scene_animType NewSceneAnim;
        // 再出力した新しいストリーム、マージ先
        public readonly List<G3dStream> NewStreams;
        // 編集済みの古いシーンアニメーション、マージ元
        public readonly scene_animType OldSceneAnim;
        // 編集済みの古いストリーム、マージ元
        public readonly List<G3dStream> OldStreams;

        // マージテーブル
        public readonly Dictionary<camera_animType, camera_animType> CameraAnimTable =
            new Dictionary<camera_animType, camera_animType>();
        public readonly Dictionary<light_animType, light_animType> LightAnimTable =
            new Dictionary<light_animType, light_animType>();
        public readonly Dictionary<fog_animType, fog_animType> FogAnimTable =
            new Dictionary<fog_animType, fog_animType>();
    }
}
