﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // ボーンビジビリティアニメーションマージャ
    public static class IfBoneVisibilityAnimMerger
    {
        // マージ用の情報
        public class IfBoneVisibilityAnimMergerInfo
        {
            public IEnumerable<IfMergeSrcDstPair> BoneNamePairTable { get; set; }
        }

        public static void Merge(IfBoneVisibilityAnimMergeContext context)
        {
            Merge(context, null);
        }

        // マージ
        public static void Merge(
            IfBoneVisibilityAnimMergeContext context,
            IfBoneVisibilityAnimMergerInfo info)
        {
            // <user_data_array> <tool_data> <user_tool_data> <comment>
            IfMergeUtility.MergeRootObject(
                context.NewBoneVisAnim, context.OldBoneVisAnim,
                context.NewStreams, context.OldStreams);

            // ボーンビジビリティアニメーションがないと処理を行わない
            if (context.NewBoneVisAnim.bone_vis_bone_anim_array == null ||
                context.NewBoneVisAnim.bone_vis_bone_anim_array.bone_vis_bone_anim == null ||
                context.OldBoneVisAnim.bone_vis_bone_anim_array == null ||
                context.OldBoneVisAnim.bone_vis_bone_anim_array.bone_vis_bone_anim == null)
            {
                return;
            }

            // <bone_vis_bone_anim> のマージ
            if (info == null || info.BoneNamePairTable == null)
            {
                IfMergeUtility.MergeByTable<bone_vis_bone_animType>(
                    context.NewBoneVisAnim.bone_vis_bone_anim_array.bone_vis_bone_anim,
                    context.BoneVisibilityTable,
                    context.NewStreams,
                    context.OldStreams,
                    MergeBoneVisAnim);
            }
            else
            {
                Dictionary<bone_vis_bone_animType, bone_vis_bone_animType> boneVisAnimTable =
                    new Dictionary<bone_vis_bone_animType, bone_vis_bone_animType>();
                IfMergeUtility.SetupTableByName(
                    boneVisAnimTable,
                    context.NewBoneVisAnim.bone_vis_bone_anim_array.bone_vis_bone_anim,
                    context.OldBoneVisAnim.bone_vis_bone_anim_array.bone_vis_bone_anim,
                    info.BoneNamePairTable);

                // マージを実行する。
                IfMergeUtility.MergeByTable<bone_vis_bone_animType>(
                    context.NewBoneVisAnim.bone_vis_bone_anim_array.bone_vis_bone_anim,
                    boneVisAnimTable,
                    context.NewStreams,
                    context.OldStreams,
                    MergeBoneVisAnim);
            }

            /// ストリームをソートする
            StreamUtility.SortStream(context.NewBoneVisAnim, context.NewStreams);
        }

        //---------------------------------------------------------------------
        // ボーンビジビリティアニメーションのマージ
        private static void MergeBoneVisAnim(
            bone_vis_bone_animType newBoneVisAnim,
            List<G3dStream> newStream,
            bone_vis_bone_animType oldBoneVisAnim,
            List<G3dStream> oldStream)
        {
            // ボーンビジビリティアニメーションのマージは廃止(SIGLO-32906)
        }
    }
}
