﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Diagnostics;
using System.IO;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // テキストスケルタルアニメーション中間ファイルフォーマッタ
    internal static class IfTextSkeletalAnimFormatter
    {
        // skeletal_anim のフォーマット
        internal static void Format(TextReader rd, TextWriter wt)
        {
            // skeletal_anim
            wt.WriteLine($"<{G3dConstant.SkeletalAnimElementName} {rd.ReadLine()}");

            // process_log
            string process_log_array = rd.ReadLine();
            string skeletal_anim_info;
            if (process_log_array == "<process_log_array")
            {
                IfTextFormatterUtility.Format_process_log_array(rd, wt);
                skeletal_anim_info = rd.ReadLine();
            }
            else
            {
                skeletal_anim_info = process_log_array;
            }

            // skeletal_anim_info
            Nintendo.Foundation.Contracts.Assertion.Operation.True(skeletal_anim_info == "<skeletal_anim_info");
            FormatSkeletalAnimInfo(rd, wt);

            // bone_anim
            FormatBoneAnim(rd, wt);

            // user_data
            string user_data_array = rd.ReadLine();
            string stream_array;
            if (user_data_array == "<user_data_array")
            {
                IfTextFormatterUtility.Format_user_data_array(rd, wt, string.Empty);
                stream_array = rd.ReadLine();
            }
            else
            {
                stream_array = user_data_array;
            }

            // stream
            string comment;
            if (stream_array == "<stream_array")
            {
                IfTextFormatterUtility.Format_stream(rd, wt);
                comment = rd.ReadLine();
            }
            else
            {
                comment = stream_array;
            }

            // comment
            string tool_data;
            if (comment == "<comment")
            {
                IfTextFormatterUtility.FormatComment(rd, wt, string.Empty);
                tool_data = rd.ReadLine();
            }
            else
            {
                tool_data = comment;
            }

            // tool_data
            string user_tool_data;
            if (tool_data == "<tool_data>")
            {
                IfTextFormatterUtility.FormatToolData(rd, wt, string.Empty);
                user_tool_data = rd.ReadLine();
            }
            else
            {
                user_tool_data = tool_data;
            }

            // user_tool_data
            string close_skeletal_anim;
            if (user_tool_data == "<user_tool_data>")
            {
                IfTextFormatterUtility.FormatUserToolData(rd, wt, string.Empty);
                close_skeletal_anim = rd.ReadLine();
            }
            else
            {
                close_skeletal_anim = user_tool_data;
            }

            Nintendo.Foundation.Contracts.Assertion.Operation.True(close_skeletal_anim == "</skeletal_anim>");
            wt.WriteLine(close_skeletal_anim);
        }

        //---------------------------------------------------------------------
        #region skeletal_anim_info
        // skeletal_anim_info のフォーマット
        private static void FormatSkeletalAnimInfo(TextReader rd, TextWriter wt)
        {
            // skeletal_anim_info
            wt.WriteLine("<skeletal_anim_info {0} {1}", rd.ReadLine(), rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", IfTextFormatterUtility.RemoveSlashBracket(rd.ReadLine()));
            wt.WriteLine("/>");
        }
        #endregion

        //---------------------------------------------------------------------
        #region bone_anim
        // bone_anim のフォーマット
        private static void FormatBoneAnim(TextReader rd, TextWriter wt)
        {
            // bone_anim_array
            string bone_anim_array = rd.ReadLine();
            Nintendo.Foundation.Contracts.Assertion.Operation.True(bone_anim_array == "<bone_anim_array");
            wt.WriteLine("{0} {1}", bone_anim_array, rd.ReadLine());

            while (true)
            {
                // bone_anim
                string bone_anim = rd.ReadLine();
                if (bone_anim != "<bone_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(bone_anim == "</bone_anim_array>");
                    wt.WriteLine("{0}", bone_anim);
                    break;
                }

                wt.WriteLine("\t{0} {1} {2} {3}",
                    bone_anim, rd.ReadLine(), rd.ReadLine(), rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());
                wt.WriteLine("\t\t{0}", IfTextFormatterUtility.RemoveBracket(rd.ReadLine()));
                wt.WriteLine("\t>");

                // bone_anim_target
                string user_data_array = FormatBoneAnimTarget(rd, wt);

                // user_data
                string close_bone_anim;
                if (user_data_array == "<user_data_array")
                {
                    IfTextFormatterUtility.Format_user_data_array(rd, wt, string.Empty);
                    close_bone_anim = rd.ReadLine();
                }
                else
                {
                    close_bone_anim = user_data_array;
                }

                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_bone_anim == "</bone_anim>");
                wt.WriteLine("\t{0}", close_bone_anim);
            }
        }

        // bone_anim_target のフォーマット
        private static string FormatBoneAnimTarget(TextReader rd, TextWriter wt)
        {
            while (true)
            {
                // bone_anim_target
                string bone_anim_target = rd.ReadLine();
                if (bone_anim_target != "<bone_anim_target") { return bone_anim_target; }

                string target = rd.ReadLine();
                string base_value = rd.ReadLine();
                wt.WriteLine("\t\t{0} {1} {2}", bone_anim_target, target, base_value);

                // カーブのフォーマット
                if (base_value.EndsWith(" />")) { continue; }
                IfTextFormatterUtility.FormatCurve(rd, wt, "\t\t\t");

                string close_bone_anim_target = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_bone_anim_target == "</bone_anim_target>");
                wt.WriteLine("\t\t{0}", close_bone_anim_target);
            }
        }
        #endregion
    }
}
