﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Diagnostics;
using System.IO;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // テキストシェーダーバリエーション中間ファイルフォーマッタ
    internal static class IfTextShaderVariationFormatter
    {
        // shader_variation のフォーマット
        internal static void Format(TextReader rd, TextWriter wt)
        {
            // shader_variation
            wt.WriteLine($"<{G3dConstant.ShaderVariationElementName} {rd.ReadLine()}");

            // shader_variation_info
            string shader_variation_info = rd.ReadLine();
            Nintendo.Foundation.Contracts.Assertion.Operation.True(shader_variation_info == "<shader_variation_info");
            wt.WriteLine("{0} {1}", shader_variation_info, rd.ReadLine());

            // target_shader
            string target_shader_array = rd.ReadLine();
            Nintendo.Foundation.Contracts.Assertion.Operation.True(target_shader_array == "<target_shader_array");
            IfTextShaderVariationFormatter.Format_target_shader_array(rd, wt);

            // stream
            string stream_array = rd.ReadLine();
            string user_tool_data;
            if (stream_array == "<stream_array")
            {
                IfTextFormatterUtility.Format_stream(rd, wt);
                user_tool_data = rd.ReadLine();
            }
            else
            {
                user_tool_data = stream_array;
            }

            // user_tool_data
            string close_shader_variation;
            if (user_tool_data == "<user_tool_data>")
            {
                IfTextFormatterUtility.FormatUserToolData(rd, wt, string.Empty);
                close_shader_variation = rd.ReadLine();
            }
            else
            {
                close_shader_variation = user_tool_data;
            }

            Nintendo.Foundation.Contracts.Assertion.Operation.True(close_shader_variation == "</shader_variation>");
            wt.WriteLine(close_shader_variation);
        }

        //---------------------------------------------------------------------
        // target_shader_array のフォーマット
        private static void Format_target_shader_array(TextReader rd, TextWriter wt)
        {
            // target_shader_array
            wt.WriteLine("<target_shader_array {0}", rd.ReadLine());

            while (true)
            {
                // target_shader
                string target_shader = rd.ReadLine();
                if (target_shader != "<target_shader")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(target_shader == "</target_shader_array>");
                    wt.WriteLine("{0}", target_shader);
                    break;
                }

                // target_shader は必ず子要素を持つ
                wt.WriteLine("\t{0} {1} {2}", target_shader, rd.ReadLine(), rd.ReadLine());

                string shader_program_array = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(shader_program_array == "<shader_program_array");
                IfTextShaderVariationFormatter.Format_shader_program_array(rd, wt);

                string close_target_shader = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_target_shader == "</target_shader>");
                wt.WriteLine("\t{0}", close_target_shader);
            }
        }

        //---------------------------------------------------------------------
        // shader_program_array のフォーマット
        private static void Format_shader_program_array(TextReader rd, TextWriter wt)
        {
            // shader_program_array
            wt.WriteLine("\t\t<shader_program_array {0}", rd.ReadLine());

            while (true)
            {
                // shader_program
                string shader_program = rd.ReadLine();
                if (shader_program != "<shader_program")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(shader_program == "</shader_program_array>");
                    wt.WriteLine("\t\t{0}", shader_program);
                    break;
                }

                string index = rd.ReadLine();
                wt.WriteLine("\t\t\t{0} {1}", shader_program, index);
                if (index.EndsWith(" />")) { continue; }

                string macro_array = rd.ReadLine();
                string option_array;
                if (macro_array == "<macro_array")
                {
                    IfTextFormatterUtility.Format_macro_array(rd, wt, "\t\t\t\t");
                    option_array = rd.ReadLine();
                }
                else
                {
                    option_array = macro_array;
                }

                // option_array
                string close_shader_program;
                if (option_array == "<option_array")
                {
                    IfTextShaderVariationFormatter.Format_option_array(rd, wt);
                    close_shader_program = rd.ReadLine();
                }
                else
                {
                    close_shader_program = option_array;
                }

                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_shader_program == "</shader_program>");
                wt.WriteLine("\t\t\t{0}", close_shader_program);
            }
        }

        //---------------------------------------------------------------------
        // option_array のフォーマット
        private static void Format_option_array(TextReader rd, TextWriter wt)
        {
            // option_array
            wt.WriteLine("\t\t\t\t<option_array {0}", rd.ReadLine());

            while (true)
            {
                // option
                string option = rd.ReadLine();
                if (option != "<option")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(option == "</option_array>");
                    wt.WriteLine("\t\t\t\t{0}", option);
                    break;
                }

                wt.WriteLine("\t\t\t\t\t{0} {1} {2} {3}",
                    option, rd.ReadLine(), rd.ReadLine(), rd.ReadLine());
            }
        }
    }
}
