﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Diagnostics;

using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // 中間ファイル圧縮
    public abstract class IfCompressor<TTarget>
    {
        // コンストラクタ
        public IfCompressor(string toStringId)
        {
            this.ToStringId = toStringId;
            this.Argument = string.Empty;
        }

        // コンストラクタ
        public IfCompressor(string toStringId, string argument)
        {
            this.ToStringId = toStringId;
            Nintendo.Foundation.Contracts.Assertion.Argument.True(argument != null);
            this.Argument = argument;
        }

        // プロセス
        public abstract string Process { get; }

        // 圧縮
        public void Compress(TTarget target, List<G3dStream> streams)
        {
            Stopwatch.Reset();
            Stopwatch.Start();

            this.Target = target;
            this.Streams = streams;

            this.PreCount = GetCount();
            Compress();
            this.PostCount = GetCount();

            Stopwatch.Stop();
        }

        // カウントの取得
        public abstract int GetCount();

        // 結果の取得
        public abstract string GetResult();

        // 圧縮
        protected abstract void Compress();

        // 文字列変換
        public override string ToString()
        {
            return IfStrings.Get(
                this.ToStringId,
                Stopwatch.ElapsedMilliseconds,
                (this.PreCount > 0) ? (100f * this.PostCount / this.PreCount) : 0,
                this.PreCount, this.PostCount);
        }

        public readonly string Argument;
        public TTarget Target { get; set; }
        public List<G3dStream> Streams { get; set; }
        public int PreCount { get; set; }
        public int PostCount { get; set; }

        protected readonly Stopwatch Stopwatch = new Stopwatch();
        protected readonly string ToStringId;
    }
}
