﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    internal class streamChecker
    {
        internal static void Check(IfCheckContext context, List<G3dStream> streams)
        {
            G3dParallel.For(0, streams.Count, delegate(int i)
            {
                CheckFloatValue(context, streams[i], i);
            });
        }

        // float 値のチェック
        private static void CheckFloatValue(IfCheckContext context,
            G3dStream stream, int streamIndex)
        {
            if (stream.type != stream_typeType.@float) { return; }

            for (int i = 0; i < stream.FloatData.Count; i++)
            {
                float value = stream.FloatData[i];

                // 無限大チェック
                if (float.IsInfinity(value))
                {
                    AddDataError(context, streamIndex, i,
                        IfStrings.Get("IfCheck_Error_Inf"));
                }

                // 非数チェック
                if (float.IsNaN(value))
                {
                    AddDataError(context, streamIndex, i,
                        IfStrings.Get("IfCheck_Error_NaN"));
                }
            }
        }

        private static void AddDataError(IfCheckContext context, int streamIndex,
            int dataIndex, string message)
        {
            context.AddError(string.Format(
                "<stream stream_index=\"{0}\">[{1}]: {2}",
                streamIndex, dataIndex, message));
        }
    }
}
