﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Xml.Serialization;

namespace nw.g3d.iflib
{
    /// <summary>
    /// 3DEditor のファイル読み込み状態
    /// </summary>
    public class export_info
    {
        /// <summary>
        /// 現在のフレーム
        /// </summary>
        [XmlAttribute]
        public float current_frame { get; set; }

        /// <summary>
        /// シーンのアニメーションセット
        /// </summary>
        public animation_set[] scene_animation_sets { get; set; }

        /// <summary>
        /// モデル
        /// </summary>
        public model[] models { get; set; }

        /// <summary>
        /// シーン以外のアニメーション
        /// </summary>
        public animation[] animations { get; set; }

        /// <summary>
        /// テスクチャ
        /// </summary>
        public texture[] textures { get; set; }

        /// <summary>
        /// シェーダー定義
        /// </summary>
        public shader_definition[] shader_definitions { get; set; }

        /// <summary>
        /// シーンアニメーション
        /// </summary>
        public animation[] scene_animations { get; set; }

        public class file
        {
            [XmlAttribute]
            public string path { get; set; }
        }

        public class animation : file { }
        public class texture : file { }
        public class shader_definition : file { }

        public class animation_set
        {
            [XmlAttribute]
            public string name { get; set; }

            [XmlAttribute]
            public bool default_animation_set { get; set; }

            /// <summary>
            /// アニメーションセットのプレビュー状態
            /// </summary>
            [XmlAttribute]
            public bool preview { get; set; }

            public animation[] animations { get; set; }
        }

        public class model : file
        {
            [XmlAttribute]
            public string name { get; set; }

            public animation_set[] animation_sets { get; set; }

            /// <summary>
            /// モデルのプレビュー情報
            /// </summary>
            public preview preview { get; set; }
        }

        /// <summary>
        /// モデルのプレビュー情報
        /// </summary>
        public class preview
        {
            [XmlAttribute]
            public string bind_model_name { get; set; }

            [XmlAttribute]
            public string bind_bone_name { get; set; }

            [XmlAttribute]
            public float[] scale { get; set; }

            [XmlAttribute]
            public float[] rotate { get; set; }

            [XmlAttribute]
            public float[] translate { get; set; }
        }
    }
}
