﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.IO;
using nw.g3d.nw4f_3dif;
using Nintendo.G3dTool.Entities;

namespace nw.g3d.ifcvtr
{
    // obj 変換用コンテキスト
    internal class ObjContext
    {
        // コンストラクタ
        internal ObjContext(string filePath, string outputPath, float magnify, bool invertUvVertical, string projectRoot)
        {
            this.FilePath = filePath;
            this.OutputPath = outputPath;
            this.Magnify = magnify;
            this.InvertUvVertical = invertUvVertical;
            this.ProjectRoot = projectRoot;
            this.CurrentGroup = string.Empty;
            this.CurrentMaterial = string.Empty;
        }

        internal IntermediateFile File { get; set; }

        internal readonly string FilePath;
        internal readonly string OutputPath;
        internal readonly float Magnify;
        internal readonly bool InvertUvVertical;
        internal readonly string ProjectRoot;
        internal readonly List<float[]> Positions = new List<float[]>();
        internal readonly List<float[]> Uvs = new List<float[]>();
        internal readonly List<float[]> Normals = new List<float[]>();
        internal readonly List<string> Mtllibs = new List<string>();
        internal readonly List<ObjShape> Shapes = new List<ObjShape>();
        internal readonly List<ObjMaterial> Materials = new List<ObjMaterial>();

        internal string CurrentGroup
        {
            get { return _currentGroup; }
            set
            {
                Nintendo.Foundation.Contracts.Assertion.Argument.True(value != null);
                _currentGroup = value;
                this.CurrentShape = null;
            }
        }
        private string _currentGroup;

        internal string CurrentMaterial
        {
            get { return _currentMaterial; }
            set
            {
                Nintendo.Foundation.Contracts.Assertion.Argument.True(value != null);
                _currentMaterial = value;
                this.CurrentShape = null;
            }
        }
        private string _currentMaterial;

        internal ObjShape CurrentShape
        {
            get
            {
                if (_currentShape == null)
                {
                    _currentShape = new ObjShape(this.CurrentGroup, this.CurrentMaterial);
                    this.Shapes.Add(_currentShape);
                }
                return _currentShape;
            }
            set { _currentShape = value; }
        }
        private ObjShape _currentShape;
    }

    //=====================================================================
    // シェイプ
    internal class ObjShape
    {
        internal ObjShape(string group, string material)
        {
            this.Group = group;
            this.Material = material;
        }

        internal readonly string Group;
        internal readonly string Material;
        internal readonly List<int[]> Faces = new List<int[]>();
    }

    //=====================================================================
    // マテリアル
    internal class ObjMaterial
    {
        internal ObjMaterial(string mtllib, string filePath, string name)
        {
            this.Mtllib = mtllib;
            this.FilePath = filePath;
            this.Name = name;
        }

        internal int TextureCount
        {
            get
            {
                int result = 0;
                if (this.AlbedoTexture != null) { result++; }
                if (this.OpacityTexture != null) { result++; }
                if (this.EmissionTexture != null) { result++; }
                if (this.SpecularTexture != null) { result++; }
                return result;
            }
        }

        internal readonly string Mtllib;
        internal readonly string FilePath;
        internal readonly string Name;
        internal readonly float[] Diffuse = new float[3] { 1f, 1f, 1f };
        internal float Opacity { get; set; } = 1f;
        internal readonly float[] Ambient = new float[3] { 0f, 0f, 0f };
        internal readonly float[] Specular = new float[3] { 0f, 0f, 0f };
        internal string AlbedoTexture { get; set; }
        internal string OpacityTexture { get; set; }
        internal string EmissionTexture { get; set; }
        internal string SpecularTexture { get; set; }
        // 法線マップに対応したい場合は Tangent への対応が必要
    }
}
