﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using Excel = Microsoft.Office.Interop.Excel;

namespace ShaderAssistExAddons.Modules.ParamCode
{
    public class ExcelContext : IDisposable
    {
        private Excel.Application application = new Excel.Application();
        private List<SheetContext> sheetContexts = new List<SheetContext>();

        public Excel.Workbook Workbook { get; set; } = null;

        public void Dispose()
        {
            if (this.Workbook != null)
            {
                this.Workbook.Close();
            }

            this.application.Quit();
        }

        public void Create()
        {
            this.Workbook = this.application.Workbooks.Add();
            Excel.Worksheet activeSheet = (Excel.Worksheet)this.Workbook.ActiveSheet;
            sheetContexts.Add(new SheetContext() { Sheet = activeSheet });
        }

        public void Open(string filePath)
        {
            this.Workbook = this.application.Workbooks.Open(filePath);
        }

        public void Save(string filePathWithoutExtension)
        {
            Nintendo.ToolFoundation.Contracts.Ensure.Equals(System.IO.Path.GetExtension(filePathWithoutExtension), ".xls");
            if (this.Workbook == null)
            {
                return;
            }

            string filePathRefined = filePathWithoutExtension.Replace('/', '\\');
            this.application.DisplayAlerts = false;
            this.Workbook.SaveAs(filePathRefined, Excel.XlFileFormat.xlOpenXMLWorkbook, Missing.Value,
                Missing.Value, false, false, Excel.XlSaveAsAccessMode.xlNoChange,
                Excel.XlSaveConflictResolution.xlUserResolution, true,
                Missing.Value, Missing.Value, Missing.Value);
        }

        public Excel.Worksheet AddWorksheet(string name)
        {
            Excel.Worksheet activeSheet = (Excel.Worksheet)this.Workbook.ActiveSheet;
            Excel.Worksheet sheet = (Excel.Worksheet)this.Workbook.Worksheets.Add(
                After: this.Workbook.Worksheets[this.Workbook.Worksheets.Count]);
            sheet.Name = name;
            sheet.StandardWidth = 30;

            // Add すると追加分がアクティベートされてしまうので元に戻す
            activeSheet.Activate();

            sheetContexts.Add(new SheetContext() { Sheet = sheet });
            return sheet;
        }

        public void SetCellValue(string cellId, string value)
        {
            Excel.Worksheet sheet = (Excel.Worksheet)this.Workbook.ActiveSheet;
            Excel.Range cell = sheet.Range[cellId];
            cell.Value = value;
        }

        public void SetCellTitleValue(string cellId, string value)
        {
            Excel.Worksheet sheet = (Excel.Worksheet)this.Workbook.ActiveSheet;
            Excel.Range cell = sheet.Range[cellId];
            cell.Value = value;
            cell.Interior.Color = Excel.XlRgbColor.rgbBlanchedAlmond;
            cell.Borders.Color = Excel.XlRgbColor.rgbBlack;
        }

        public void ActivateWorksheet(string name)
        {
            Excel.Worksheet sheet = (Excel.Worksheet)this.Workbook.Worksheets[name];
            sheet.Activate();
        }

        public int GetActiveSheetRow()
        {
            Excel.Worksheet sheet = (Excel.Worksheet)this.Workbook.ActiveSheet;
            SheetContext context = FindSheetContext(sheet);
            return context.CurrentRow;
        }

        public void SetActiveSheetRow(int row)
        {
            Excel.Worksheet sheet = (Excel.Worksheet)this.Workbook.ActiveSheet;
            SheetContext context = FindSheetContext(sheet);
            context.CurrentRow = row;
        }

        private class SheetContext
        {
            public Excel.Worksheet Sheet { get; set; } = null;
            public int CurrentRow { get; set; } = 1;
        }

        private SheetContext FindSheetContext(Excel.Worksheet sheet)
        {
            foreach (var context in this.sheetContexts)
            {
                if (context.Sheet == sheet)
                {
                    return context;
                }
            }

            return null;
        }
    }
}
