﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <BinaryBlock.h>
#include <algorithm>
#include <functional>

namespace nn {
namespace g3dTool {

void BinaryBlock::CalculateOffset( std::shared_ptr<Context> pCtx )
{
    Context& ctx = *pCtx;
    for ( int index = 0; index < Context::MemBlockType_Count; ++index )
    {
        if ( m_Block[index].size )
        {
            if ( index == Context::MemBlockType_ExternalFile )
            {
                int insertPos = 0;

                // ソート済みリストへの追加
                for ( auto iter = ctx.exFileChunks.begin(); iter != ctx.exFileChunks.end(); ++iter )
                {
                    if( ( *iter )->alignment < m_Block[ Context::MemBlockType_ExternalFile ].alignment )
                    {
                        break;
                    }
                    ++insertPos;
                }

                ctx.exFileChunks.insert( ctx.exFileChunks.begin() + insertPos, &m_Block[ Context::MemBlockType_ExternalFile ] );

                if ( insertPos == 0 )
                {
                    m_Block[ Context::MemBlockType_ExternalFile ].offset = 0;
                }
                else
                {
                    m_Block[ Context::MemBlockType_ExternalFile ].offset =
                        ctx.exFileChunks[ insertPos-1 ]->offset + ctx.exFileChunks[ insertPos-1 ]->size;
                }

                for (int i = insertPos + 1; i < static_cast<int>(ctx.exFileChunks.size()); ++i)
                {
                    ctx.exFileChunks[i]->offset = ctx.exFileChunks[i-1]->offset + ctx.exFileChunks[i-1]->size;
                }
            }
            else
            {
                m_Block[ index ].offset = ctx.GetMemBlockSize( static_cast< Context::MemBlockType >( index ) );
            }
            ctx.SetMemBlockSize( static_cast< Context::MemBlockType >( index ),
                m_Block[ index ].size + ctx.GetMemBlockSize( static_cast< Context::MemBlockType >( index ) ) );
        }
    }
}

void* BinaryBlock::GetPtr( std::shared_ptr<Context> pCtx, Context::MemBlockType type, ptrdiff_t offset )
{
    if ( m_Block[ type ].size > 0 )
    {
        return nw::g3d::tool::util::AddOffset( pCtx->GetMemBlockPtr( type ), m_Block[ type ].offset + offset );
    }
    return nullptr;
}

}
}
