﻿namespace G3dCore.Messaging
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// ViewModelとViewの間での情報のやり取りを行うメッセージ
    /// </summary>
    public class Message
    {
        /// <summary>
        /// メッセージの本体
        /// </summary>
        public object Body { get; private set; }

        /// <summary>
        /// ViewからViewModelへのメッセージのレスポンス
        /// </summary>
        public object Response { get; set; }

        /// <summary>
        /// Bodyを指定してMessageを作成する
        /// </summary>
        public Message(object body)
        {
            this.Body = body;
        }
    }
}
