﻿namespace G3dCore.Entities
{
    using System;
    using System.Collections.Generic;
    using System.Collections.Specialized;
    using System.ComponentModel;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    public abstract class ObservableEntity<TEntity> : Entity<TEntity> where TEntity : class
    {
        protected void OnCollectionChanged<TItem>(object sender, NotifyCollectionChangedEventArgs e) where TItem : INotifyPropertyChanged
        {
            if (e.NewItems != null)
            {
                foreach (var item in e.NewItems)
                {
                    TItem observableItem = (TItem)item;
                    observableItem.PropertyChanged += this.OnCollectionPropertyChanged;
                }
            }

            if (e.OldItems != null)
            {
                foreach (var item in e.OldItems)
                {
                    TItem observableItem = (TItem)item;
                    observableItem.PropertyChanged -= this.OnCollectionPropertyChanged;
                }
            }

            this.CalcCRC();
        }

        private void OnCollectionPropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            if (e.PropertyName == "IsDirty")
            {
                this.CalcCRC();
            }
        }
    }
}
