﻿namespace ChalkboardCore
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.ComponentModel;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Data;
    using System.Xml;
    using System.Xml.Serialization;
    using Opal.App;
    using Opal.Configurations;
    using Opal.Services;
    using Opal.ViewModels;

    /// <summary>
    /// Chalkboard 用コンフィグクラスです。
    /// </summary>
    public sealed class ChalkboardConfig : Config
    {
        private string filePath = string.Empty;

        /// <summary>
        /// 検索パスです。
        /// </summary>
        [XmlElement("SearchPath")]
        public List<SearchPath> SearchPaths { get; set; }

        /// <summary>
        /// Chalkboard アドオンを使用するかどうかです。
        /// </summary>
        public bool UseChalkboardAddons { get; set; }

        /// <summary>
        /// Effect アドオンを使用するかどうかです。
        /// </summary>
        public bool UseEffectAddons { get; set; }

        /// <summary>
        /// G3d アドオンを使用するかどうかです。
        /// </summary>
        public bool UseG3dAddons { get; set; }

        /// <summary>
        /// ShaderAssist アドオンを使用するかどうかです。
        /// </summary>
        public bool UseShaderAssistAddons { get; set; }

        /// <summary>
        /// Sound アドオンを使用するかどうかです。
        /// </summary>
        public bool UseSoundAddons { get; set; }

        /// <summary>
        /// コンフィグファイルをロードします。
        /// </summary>
        /// <param name="path">コンフィグファイルのパスです。</param>
        /// <returns>ロードしたコンフィグを返します。</returns>
        public static ChalkboardConfig Load(string path)
        {
            var config = Config.Load<ChalkboardConfig>(path);
            if (config == null)
            {
                config = new ChalkboardConfig();
            }

            config.filePath = path;

            return config;
        }

        /// <summary>
        /// コンフィグファイルを保存します。
        /// </summary>
        public override void Save()
        {
            Config.Save<ChalkboardConfig>(this, this.filePath);
        }

        /// <summary>
        /// 検索パスです。
        /// </summary>
        [Serializable]
        public class SearchPath
        {
            private string cashPath = null;

            /// <summary>
            /// 名前です。
            /// </summary>
            [XmlAttribute]
            public string Name { get; set; }

            /// <summary>
            /// 再帰的に検索するかどうかです。
            /// </summary>
            [XmlAttribute]
            public bool Recursive { get; set; }

            /// <summary>
            /// パスです。
            /// </summary>
            [XmlText]
            public string PathXml { get; set; }

            /// <summary>
            /// パスを取得します。
            /// </summary>
            /// <returns>パスを返します。</returns>
            public string GetPath()
            {
                if (this.cashPath != null)
                {
                    return this.cashPath;
                }

                if (this.PathXml.Contains("%"))
                {
                    this.cashPath = Environment.ExpandEnvironmentVariables(this.PathXml);
                }
                else
                {
                    this.cashPath = this.PathXml;
                }

                return this.cashPath;
            }
        }
    }
}
