﻿namespace ShaderAssistAddons.Windows.Controls
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using System.Windows.Media;

    public class ListItemStyleSelector : StyleSelector
    {
        public Color Back1 = Colors.White;
        public Color Back2 = Color.FromRgb(0xFC, 0xFD, 0xFD);
        public Color Rule = Color.FromRgb(0xE0, 0xE3, 0xEE);

        public override Style SelectStyle(object item, DependencyObject container)
        {
            ListView listView = ItemsControl.ItemsControlFromItemContainer(container) as ListView;
            int index = listView.ItemContainerGenerator.IndexFromContainer(container);

            Style stockListItemStyle = new Style(typeof(ListViewItem));
            stockListItemStyle.Setters.Add(new Setter(ListViewItem.BackgroundProperty, new SolidColorBrush(index % 2 == 0 ? Back1 : Back2)));

            stockListItemStyle.Setters.Add(new Setter(ListViewItem.BorderBrushProperty, new SolidColorBrush(Rule)));
            stockListItemStyle.Setters.Add(new Setter(ListViewItem.BorderThicknessProperty, new Thickness(0, 0, 0, 1)));

            return stockListItemStyle;
        }
    }
}
