﻿namespace ShaderAssistAddons.Tools
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using G3dCore.Resources;
    using G3dCore.ViewModels;
    using Opal.App;
    using Opal.Plugins;
    using Opal.Storages;
    using Opal.ViewModels;
    using Opal.Windows.Tools;
    using ShaderAssistAddons.Modules.ShaderConfig.ViewModels;
    using ShaderAssistAddons.Modules.ShaderConfig.Views;
    using ShaderAssistAddons.Properties;

    /// <summary>
    /// シェーダ設定編集ツール作成クラスです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public class EditShaderConfigToolMaker : ToolMakerPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public EditShaderConfigToolMaker()
            : base("EditShaderConfig", Labels.EditShaderConfig)
        {
        }

        /// <summary>
        /// ビューを生成します。
        /// </summary>
        /// <returns>ビューのインスタンスを返します。</returns>
        public override Control CreateView()
        {
            return new EditShaderConfigView();
        }

        /// <summary>
        /// ビューに対応するビューモデルを生成します。
        /// </summary>
        /// <returns>ビューモデルのインスタンスを返します。</returns>
        public override ToolViewModel CreateViewModel()
        {
            var viewModel = new EditShaderConfigViewModel();
            viewModel.Title = Labels.EditShaderConfig;
            return viewModel;
        }
    }
}
