﻿namespace ShaderAssistAddons.Modules.ShaderConfig.ViewModels
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.ViewModels;
    using ShaderAssistAddons.Modules.ShaderConfig.Commands;

    public enum WizardType
    {
        Fsc,
        Fsv
    };

    /// <summary>
    /// ウィザードダイアログのビューモデルです。
    /// </summary>
    public class WizardDialogViewModel : ViewModel
    {
        WizardViewModel _wizardViewModelBase;
        WizardType _type = WizardType.Fsc;

        WizardPageViewModel _currentPageViewModel;
        int _pageNo;

        string _goNextContent;

        DelegateCommand _goNextCommand;
        DelegateCommand _goBackCommand;

        //---------------------------------------------------------------------

        public WizardType WizardType
        {
            get
            {
                return this._type;
            }

            set
            {
                if (value != this._type)
                {
                    this._type = value;
                    this.RaisePropertyChanged();
                }
            }
        }

        public WizardPageViewModel CurrentPageViewModel
        {
            get
            {
                return _currentPageViewModel;
            }

            protected set
            {
                if (value != _currentPageViewModel)
                {
                    Debug.Assert(value != null);

                    _currentPageViewModel = value;
                    this.RaisePropertyChanged("CurrentPageViewModel");

                    if (_pageNo + 1 < _wizardViewModelBase.PageCount)
                    {
                        GoNextContent = "次へ >";
                    }
                    else
                    {
                        GoNextContent = "完了";
                    }
                }
            }
        }

        public string GoNextContent
        {
            get { return _goNextContent; }
            protected set
            {
                if (value != _goNextContent)
                {
                    _goNextContent = value;
                    this.RaisePropertyChanged();
                }
            }
        }

        public string Title
        {
            get { return _wizardViewModelBase.Title; }
        }

        public bool IsLastPage
        {
            get { return _pageNo + 1 == _wizardViewModelBase.PageCount; }
        }

        //---------------------------------------------------------------------

        public DelegateCommand GoNextCommand
        {
            get { return this._goNextCommand; }
        }

        public DelegateCommand GoBackCommand
        {
            get { return this._goBackCommand; }
        }

        //---------------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public WizardDialogViewModel(WizardType type, WizardViewModel wizardViewModelBase)
        {
            Debug.Assert(wizardViewModelBase != null);

            _wizardViewModelBase = wizardViewModelBase;
            _type = type;

            _goNextCommand = new DelegateCommand(GoNextExecute, CanGoNext);
            _goBackCommand = new DelegateCommand(GoBackExecute, CanGoBack);

            CurrentPageViewModel = _wizardViewModelBase.GetPageViewModel(_pageNo = 0);
        }

        //---------------------------------------------------------------------

        /// <summary>
        /// 次のページへ進みます。
        /// </summary>
        private void GoNextExecute()
        {
            _wizardViewModelBase.ProcPage(_pageNo, true);

            if (_pageNo + 1 < _wizardViewModelBase.PageCount)
            {
                ++_pageNo;
                CurrentPageViewModel = _wizardViewModelBase.GetPageViewModel(_pageNo);
            }
        }

        /// <summary>
        /// 次のページへ進めるかを返します。
        /// </summary>
        private bool CanGoNext()
        {
            return CurrentPageViewModel.CanGoNext();
        }

        /// <summary>
        /// 前のページへ進みます。
        /// </summary>
        private void GoBackExecute()
        {
            _wizardViewModelBase.ProcPage(_pageNo, false);
            --_pageNo;
            CurrentPageViewModel = _wizardViewModelBase.GetPageViewModel(_pageNo);
        }

        /// <summary>
        /// 前のページへ進めるかを返します。
        /// </summary>
        private bool CanGoBack()
        {
            return (_pageNo - 1 >= 0) && CurrentPageViewModel.CanGoBack();
        }
    }
}
