﻿namespace ShaderAssistAddons.Modules.ShaderConfig.ViewModels
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using G3dCore.Resources;
    using Opal.ViewModels;

    public class ShaderSourceListItemViewModel : ViewModel
    {
        public enum ItemTypes
        {
            IncludeFile,
            ForceIncludeFile,
            VertexShader,
            GeometryShader,
            FragmentShader,
            ComputeShader
        }

        bool _isSelected;
        ItemTypes _fileType = ItemTypes.IncludeFile;
        string _strFileType = string.Empty;
        string _includePath;
        string _filePath = string.Empty;

        //---------------------------------------------------------------------

        public bool IsSelected
        {
            get { return _isSelected; }
            set
            {
                if (value != _isSelected)
                {
                    _isSelected = value;
                    this.RaisePropertyChanged("IsSelected");
                }
            }
        }

        public ItemTypes FileType
        {
            get { return _fileType; }
            set
            {
                _fileType = value;

                switch (_fileType)
                {
                    case ItemTypes.IncludeFile:
                        {
                            StrFileType = Labels.IncludeFile;
                        }
                        break;
                    case ItemTypes.ForceIncludeFile:
                        {
                            StrFileType = Labels.ForceIncludeFile;
                        }
                        break;
                    case ItemTypes.VertexShader:
                        {
                            StrFileType = Labels.VertexShader;
                        }
                        break;
                    case ItemTypes.GeometryShader:
                        {
                            StrFileType = Labels.GeometryShader;
                        }
                        break;
                    case ItemTypes.FragmentShader:
                        {
                            StrFileType = Labels.FragmentShader;
                        }
                        break;
                    case ItemTypes.ComputeShader:
                        {
                            StrFileType = Labels.ComputeShader;
                        }
                        break;
                }
            }
        }

        public string StrFileType
        {
            get { return _strFileType; }
            set
            {
                if (value != _strFileType)
                {
                    _strFileType = value;
                    this.RaisePropertyChanged("StrFileType");
                }
            }
        }

        public string IncludePath
        {
            get { return _includePath; }
            set
            {
                if (value != _includePath)
                {
                    _includePath = value;
                    this.RaisePropertyChanged("IncludePath");
                }
            }
        }

        public string FilePath
        {
            get { return _filePath; }
            set
            {
                if (value != _filePath)
                {
                    _filePath = value;
                    this.RaisePropertyChanged("FilePath");
                }
            }
        }
    }
}
