﻿namespace ShaderAssistAddons.Modules.ShaderConfig.Actions
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Forms;
    using System.Windows.Interactivity;
    using G3dCore.Messaging;
    using ShaderAssistAddons.Modules.ShaderConfig.ViewModels;
    using ShaderAssistAddons.Modules.ShaderConfig.Views;

    /// <summary>
    /// ウィザードを表示するアクション
    /// </summary>
    public class WizardAction : TriggerAction<DependencyObject>
    {
        /// <summary>
        /// アクションを呼び出します。
        /// </summary>
        /// <param name="parameter">アクションへのパラメーター。</param>
        protected override void Invoke(object parameter)
        {
            var args = parameter as MessageEventArgs;
            if (args == null)
            {
                return;
            }

            var input = (InputArg)args.Message.Body;

            var wizardDialog = new WizardDialog();
            wizardDialog.Owner = System.Windows.Application.Current.MainWindow;
            wizardDialog.SizeToContent = SizeToContent.Height;
            wizardDialog.DataContext = new WizardDialogViewModel(WizardType.Fsc, input.WizardViewModel);

            var output = new OutputArg();
            output.Result = wizardDialog.ShowDialog();

            args.Message.Response = output;
            args.Callback(args.Message);
        }

        public class InputArg
        {
            public WizardViewModel WizardViewModel
            {
                get;
                set;
            }
        }

        public class OutputArg
        {
            public bool? Result
            {
                get;
                internal set;
            }
        }
    }
}
