﻿namespace ShaderAssistAddons.Modules.FileList.Views
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.IO;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using System.Windows.Data;
    using System.Windows.Documents;
    using System.Windows.Input;
    using System.Windows.Media;
    using System.Windows.Media.Imaging;
    using System.Windows.Navigation;
    using System.Windows.Shapes;
    using G3dCore.ViewModels;

    /// <summary>
    /// FileListView.xaml の相互作用ロジック
    /// </summary>
    public partial class FileListView : UserControl
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public FileListView()
        {
            this.InitializeComponent();
        }

        private void TreeViewItem_MouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            this.OpenSelectedDocument();
        }

        private void OpenSelectedFilesMenuItem_Click(object sender, RoutedEventArgs e)
        {
            this.OpenSelectedDocument();
        }

        private void CloseSelectedFilesMenuItem_Click(object sender, RoutedEventArgs e)
        {
            var selectedItem = this.FilesTreeView.SelectedItem as G3dFileViewModel;
            if (selectedItem != null)
            {
                selectedItem.ConfirmAndCloseDocument();
            }
        }

        private void OpenFolderInExplorerMenuItem_Click(object sender, RoutedEventArgs e)
        {
            var selectedItem = this.FilesTreeView.SelectedItem as G3dFileViewModel;
            if (selectedItem != null)
            {
                if (File.Exists(selectedItem.FilePath))
                {
                    Process.Start(System.IO.Path.GetDirectoryName(selectedItem.FilePath));
                }
            }
        }

        private void OpenSelectedDocument()
        {
            var selectedItem = this.FilesTreeView.SelectedItem as G3dFileViewModel;
            if (selectedItem != null)
            {
                selectedItem.OpenDocument();
            }
        }
    }
}
