﻿namespace Chalkboard
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Linq;
    using System.Reflection;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using System.Windows.Data;
    using System.Windows.Documents;
    using System.Windows.Input;
    using System.Windows.Media;
    using System.Windows.Media.Imaging;
    using System.Windows.Navigation;
    using Opal.Utilities;
    using Xceed.Wpf.AvalonDock.Layout.Serialization;

    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public MainWindow()
        {
            this.InitializeComponent();

            this.Width = Properties.Settings.Default.WindowWidth;
            this.Height = Properties.Settings.Default.WindowHeight;
        }

        /// <summary>
        /// レイアウトをロードします。
        /// </summary>
        public void LoadLayout()
        {
            var layout = new XmlLayoutSerializer(this.dockManager);
            layout.LayoutSerializationCallback += LayoutUtility.CallLayoutSerialization;

            layout.Deserialize(LayoutUtility.LayoutFile);
        }

        private void OnUnloaded(object sender, RoutedEventArgs e)
        {
            this.SaveLayout();

            Properties.Settings.Default.WindowWidth = this.Width;
            Properties.Settings.Default.WindowHeight = this.Height;
            Properties.Settings.Default.Save();
        }

        private void SaveLayout()
        {
            var layout = new XmlLayoutSerializer(this.dockManager);
            layout.Serialize(LayoutUtility.LayoutFile);
        }
    }
}
