﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using App.Data;
using App.Utility;
using ConfigCommon;
using nw.g3d.nw4f_3dif;

namespace Viewer
{
    /// <summary>
    /// 基本メッセージ
    /// </summary>
    public abstract class BaseMessage
    {
        /// <summary>実行</summary>
        public abstract void Execute();
        /// <summary>メッセージカテゴリー</summary>
        protected abstract MessageCategory _messageCategory { get; }
        /// <summary>メッセージ圧縮可能フラグ。</summary>
        protected bool _isCompressible = false;
        /// <summary>メッセージ圧縮可能フラグ。</summary>]
        /// <remarks>true に設定するときはIsSameTarget を適切に実装すること!</remarks>
        public bool IsCompressible
        {
            get{return _isCompressible;}
            protected set {_isCompressible = value; }
        }
        /// <summary>実行</summary>
        public virtual bool IsSameTarget(BaseMessage msg)
        {
            return true;
        }

        public virtual bool Anihhilate(BaseMessage msg)
        {
            return false;
        }

        /// <summary>メッセージ送信</summary>
        protected void Push()
        {
            Manager.Instance.PushMessage(this);
        }

        //---------------------------------------------------------------------
        /// <summary>
        /// データ重複チェック。
        /// </summary>
        protected static object CheckSameData(ArrayList targets, object[] data)
        {
            object firstObject = data[0];
            for (int i = 0; i < data.Length; i++)
            {
                if (!firstObject.Equals(data[i])) { return null; }
            }
            return firstObject;
        }

        /// <summary>メッセージタイプか同じかどうか？</summary>
        public bool IsCategoryEqual(MessageCategory dst)
        {
            if (dst == _messageCategory)
            {
                return true;
            }
            return false;
        }

        /// <summary>
        /// ドキュメント(モデル、テクスチャ、アニメーション等)からnw4f_3difをコピーする。
        /// </summary>
        // todo:BaseMessage 以外でも使われているので定義クラスを分けたい
        public static nw4f_3difType CopyNW4F3DIF(IntermediateFileDocument intermediateFile)
        {
            nw4f_3difType nw4f_3dif = ObjectUtility.CloneWithXmlSerializer(intermediateFile.Create_nw4f_3difType(true));
            //nw4f_3difType nw4f_3dif = ObjectUtility.Clone(intermediateFile.Create_nw4f_3difType(true));
            nw4f_3dif.file_info = intermediateFile.file_info;
            // バイナリ中間ファイルの場合、nw4f_3difからストリームを削除する。
            if (G3dStreamUtility.HasStreamArray(nw4f_3dif))
            {
                nw4f_3dif.RootElement.stream_array = null;
            }
            return nw4f_3dif;
        }

        /// <summary>
        /// ドキュメント(モデル、テクスチャ、アニメーション等)からstreamを取得。
        /// </summary>
        // todo:BaseMessage 以外でも使われているので定義クラスを分けたい
        public static List<G3dStream> GetStream(IntermediateFileDocument intermediateFile)
        {
            // リストを作成して返します。
            List<G3dStream> streams = new List<G3dStream>(intermediateFile.BinaryStreams);
            return streams;
        }

        /// <summary>
        /// ドキュメント(参照ファイルを含んだリスト)を取得。
        /// </summary>
        // todo:BaseMessage 以外でも使われているので定義クラスを分けたい
        public static List<Document> GetDocuments(Document document)
        {
            var docs = new List<Document>()
            {
                document
            };

            // 参照ファイル(テクスチャ)を取得する。
            docs.AddRange(document.ReferenceDocuments.Where(x => x.ObjectID == GuiObjectID.Texture));

            return docs;
        }

    }
}
