﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace App.Utility
{
    public class DisposableCollection<T> : IDisposable where T : IDisposable
    {
        public class ItemDisposingEventArgs
        {
            public T Item
            {
                get;
                private set;
            }

            public ItemDisposingEventArgs(T item)
            {
                Item = item;
            }
        }
        public delegate void ItemDisposingEventHandler(object sender, ItemDisposingEventArgs e);

        public event ItemDisposingEventHandler ItemDisposing;

        private readonly T[] items_;

        public DisposableCollection(IEnumerable<T> items)
        {
            items_ = (items != null) ? items.Where(x => x != null).ToArray() : new T[] { };
        }

        public void Dispose()
        {
            if (ItemDisposing != null)
            {
                foreach (var item in items_.Reverse())
                {
                    ItemDisposing(this, new ItemDisposingEventArgs(item));
                    item.Dispose();
                }
            }
            else
            {
                foreach (var item in items_.Reverse())
                {
                    item.Dispose();
                }
            }
        }
    }
}
