﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Drawing;
using App.Data;
using App.Properties;
using nw.g3d.nw4f_3dif;

namespace App.Utility
{
    /// 定数クラス。
    public static class Const
    {
        private static readonly Pen clickableControlFramePen = new Pen(Color.FromArgb(228, 192, 100));

        // クリック可能コントロールの枠線のペン
        public static Pen ClickableControlFramePen{ get{ return clickableControlFramePen; } }

        // 参照切れの色
        public static Color DisreferenceColor{ get{ return Color.Gray; } }

        // 未設定の色
        public static Color UnsettingColor{ get{ return Color.Red; } }

        // テクスチャディレクトリ名
        // TODO:他のクラスに移すかも
        public static string TexturesDirectoryName{ get{ return "textures"; } }

        // バイナリリソースの拡張子
        // TODO:他のクラスに移すかも
        public const string Bfres = "bfres";

        // バイナリリソースの拡張子
        // TODO:他のクラスに移すかも
        public const string DotBfres = ".bfres";

        // ドキュメントファイル拡張子とイメージの辞書
        public static readonly Dictionary<string, Image> IconImages = new Dictionary<string, Image>()
        {
            {ProjectDocument.DefaultDotExt.Substring(1),		Resources.TreeView_Doc_Project},
            {G3dPath.ModelExtension.Substring(1),				Resources.TreeView_Doc_Model},
            {G3dPath.TextureExtension.Substring(1),				Resources.TreeView_Doc_Texture},
            {G3dPath.SkeletalAnimExtension.Substring(1),		Resources.TreeView_Doc_SkeletalAnimation},
            {G3dPath.MaterialAnimExtension.Substring(1),        Resources.TreeView_Doc_MaterialAnimation},
            {G3dPath.ShaderParamAnimExtension.Substring(1),		Resources.TreeView_Doc_ShaderParameterAnimation},
            {G3dPath.ColorAnimExtension.Substring(1),			Resources.TreeView_Doc_ColorAnimation},
            {G3dPath.TexSrtAnimExtension.Substring(1),			Resources.TreeView_Doc_TextureSrtAnimation},
            {G3dPath.TexPatternAnimExtension.Substring(1),		Resources.TreeView_Doc_TexturePatternAnimation},
            {G3dPath.BoneVisibilityAnimExtension.Substring(1),	Resources.TreeView_Doc_BoneVisibilityAnimation},
            {G3dPath.MatVisibilityAnimExtension.Substring(1),	Resources.TreeView_Doc_MaterialVisibilityAnimation},
            {G3dPath.ShapeAnimExtension.Substring(1),			Resources.TreeView_Doc_ShapeAnimation},
            {G3dPath.SceneAnimExtension.Substring(1),			Resources.TreeView_Doc_SceneAnimation},
            {G3dPath.ShaderDefinitionExtension.Substring(1), Resources.TreeView_Doc_ShaderDefinition},
            {G3dPath.MaterialExtension.Substring(1), Resources.TreeView_Doc_SeparateMaterial},
            {"tga", Resources.TreeView_Doc_Texture},
        };
    }
}
