﻿using App.Data;
using App.res;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class ShapePropertyPanel : ObjectPropertyPanel
    {
        private PropertyCategoryNode ctgGeneral;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ShapePropertyPanel()
        {
            InitializeCategoryView();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_shape_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
            ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_Shape_General, PropertyPageID.ShapeGeneral, ShapeGeneralPage.CreateInstance,
                updateModifiedFunc: () => ShapeGeneralPage.IsModified(ActiveTarget));
            var ctgRoot = RegisterCategory(0, Strings.ObjectPropertyPanel_Shape_Root, PropertyPageID.ShapeRoot, ShapeRootPage.CreateInstance);
            var ctgMesh = RegisterCategory(1, Strings.ObjectPropertyPanel_Shape_Mesh, PropertyPageID.ShapeMesh, ShapeMeshPage.CreateInstance,
                updateModifiedFunc: () => ShapeMeshPage.IsModified(ActiveTarget));
            var ctgVertex = RegisterCategory(1, Strings.ObjectPropertyPanel_Shape_Vertex, PropertyPageID.ShapeVertex, ShapeVertexPage.CreateInstance,
                updateModifiedFunc: () => ShapeVertexPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgMesh);
                ctgRoot.Nodes.Add(ctgVertex);
            }

            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private Shape ActiveTarget
        {
            get { return (Shape)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            CategoryView.SelectedNode = ctgGeneral;
        }
    }
}
