﻿using App.Data;
using App.res;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class SceneAnimationPropertyPanel : AnimationObjectPropertyPanel
    {
        private PropertyCategoryNode ctgRoot;
        private PropertyCategoryNode ctgGeneral;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public SceneAnimationPropertyPanel()
        {
            InitializeCategoryView();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
                ctgRoot = RegisterCategory(0, Strings.ObjectPropertyPanel_SceneAnimation_Root, PropertyPageID.SceneAnimationRoot, SceneAnimationRootPage.CreateInstance);
                ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_SceneAnimation_General, PropertyPageID.SceneAnimationGeneral, SceneAnimationGeneralPage.CreateInstance,
                    updateModifiedFunc: () => SceneAnimationGeneralPage.IsModified(ActiveTarget));
            var ctgFileInfo = RegisterCategory(1, Strings.ObjectPropertyPanel_FileInformation, PropertyPageID.FileInformation, FileInformationPage.CreateInstance,
                    updateModifiedFunc: () => FileInformationPage.IsModified(ActiveTarget));
            var ctgOptLog = RegisterCategory(1, Strings.ObjectPropertyPanel_OptimizationLog, PropertyPageID.OptimizationLog, OptimizationLogPage.CreateInstance);
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData, PropertyPageID.UserData, UserDataPage.CreateInstance,
                    updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgFileInfo);
                ctgRoot.Nodes.Add(ctgOptLog);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
        }


        //protected override void OnAfterUpdateForm()
        //{
        //    ctgRoot.Text = (ActiveTarget is ColorAnimation     ) ? Strings.ObjectPropertyPanel_ColorAnimation_Root      :
        //                   (ActiveTarget is TextureSrtAnimation) ? Strings.ObjectPropertyPanel_TextureSrtAnimation_Root :
        //                                                           Strings.ObjectPropertyPanel_SceneAnimation_Root;
        //}

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private SceneAnimation ActiveTarget
        {
            get { return (SceneAnimation)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            CategoryView.SelectedNode = ctgGeneral;
        }

    }
}
