﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Linq;
using App.Data;
using App.res;
using ConfigCommon;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class CameraAnimationPanel : AnimationObjectPropertyPanel
    {
        private PropertyCategoryNode ctgGeneral;
        private PropertyCategoryNode ctgCurveEdit;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public CameraAnimationPanel()
        {
            InitializeCategoryView();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
            var ctgRoot = RegisterCategory(0, Strings.ObjectPropertyPanel_CameraAnimation_Root, PropertyPageID.CameraAnimationRoot, CameraAnimationRootPage.CreateInstance);
                ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_CameraAnimation_General, PropertyPageID.CameraAnimationGeneral, CameraAnimationGeneralPage.CreateInstance,
                    updateModifiedFunc: () => CameraAnimationGeneralPage.IsModified(ActiveTarget));
                ctgCurveEdit = RegisterCategory(1, Strings.ObjectPropertyPanel_CameraAnimation_CurveEdit, PropertyPageID.CameraAnimationCurveEdit, CameraAnimationCurveEditPage.CreateInstance,
                    updateModifiedFunc: () => ActiveTarget?.IsCurvesModified() == true);
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData, PropertyPageID.UserData, UserDataPage.CreateInstance,
                    updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgCurveEdit);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private CameraAnimation ActiveTarget
        {
            get { return (CameraAnimation)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            if (ActiveTarget != null)
            {
                float baseValue;
                if (ActiveTarget.CameraAnimTargets.Any(x => x != null && x.KeyFrames.Any() && !x.KeyFrames.IsConstantCurve(out baseValue)))
                {
                    CategoryView.SelectedNode = ctgCurveEdit;
                    return;
                }
            }
            CategoryView.SelectedNode = ctgGeneral;
        }

        protected override void Event_Document_PropertyChanged(object sender, IEnumerable<DocumentPropertyChangedArgs> e)
        {
            if (e.Any(x => x is SceneAnimationContentArg))
            {
                foreach (var target in Targets.GetObjects(GuiObjectID.CameraAnimation).OfType<CameraAnimation>().ToArray())
                {
                    if (!target.Owner.CameraAnims.Contains(target))
                    {
                        Targets.Remove(target);
                    }
                }
                if (Targets.IsEmpty)
                {
                    Owner.Close();
                    return;
                }
            }
            base.Event_Document_PropertyChanged(sender, e);
        }
    }
}
