﻿using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using App.Data;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit
{
    public partial class OptimizationLogPage : ObjectPropertyPage
    {
        public OptimizationLogPage() :
            base(PropertyPageID.OptimizationLog)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_model_property_window_optiomization_log_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new OptimizationLogPage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            Debug.Assert(Targets.Active is IntermediateFileDocument);

            UpdateFormInternal((Targets.Active as IntermediateFileDocument).process_log_array);
        }

        private void UpdateFormInternal(process_log_arrayType optimizeLogArray)
        {
            if ((optimizeLogArray == null) || (optimizeLogArray.process_log.Any() == false))
            {
                pnlLogPanel.Visible = false;
            }
            else
            {
                while (pnlLogPanel.Controls.Count > optimizeLogArray.process_log.Length)
                {
                    pnlLogPanel.Controls.RemoveAt(pnlLogPanel.Controls.Count - 1);
                }

                while (pnlLogPanel.Controls.Count < optimizeLogArray.process_log.Length)
                {
                    var optimizationLog = new OptimizationLog()
                    {
                        Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right
                    };

                    pnlLogPanel.Controls.Add(optimizationLog);
                }

                int index = 0;
                foreach (var log in optimizeLogArray.process_log)
                {
                    var optimizationLog = pnlLogPanel.Controls[index] as OptimizationLog;

                    optimizationLog.Update(log);

                    optimizationLog.Size = new Size(Width - 16, optimizationLog.Height);
                    optimizationLog.Location =
                        (index == 0) ?
                            new Point(8, 8) :
                            new Point(8, pnlLogPanel.Controls[index - 1].Bounds.Bottom);

                    ++ index;
                }

                pnlLogPanel.Visible = true;
            }
        }
    }
}
