﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows.Forms;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit
{
    public partial class OptimizationLog : UserControl
    {
        private string OptimizeLogProcess
        {
            set
            {
                lblProcess.Text = value;
            }
        }

        private string Argument
        {
            set
            {
                ltbArgument.Text = string.IsNullOrEmpty(value) ? string.Empty : value.Trim();
            }
        }

        private string Result
        {
            set
            {
                ltbResult.Text = string.IsNullOrEmpty(value) ? string.Empty : value.Trim();
            }
        }

        private bool IsEnabledArgument
        {
            get
            {
                return ltbArgument.Text != string.Empty;
            }
        }

        private bool IsEnabledResult
        {
            get
            {
                return ltbResult.Text != string.Empty;
            }
        }

        private readonly int baseHeight_;

        public OptimizationLog()
        {
            InitializeComponent();

            baseHeight_ = Height;
        }

        public void Update(process_logType optimizeLog)
        {
            OptimizeLogProcess	= optimizeLog.process;
            Argument			= optimizeLog.argument;
            Result				= optimizeLog.Value;

            lblArgument.Visible = IsEnabledArgument;
            ltbArgument.Visible = IsEnabledArgument;
            lblResult.Visible   = IsEnabledResult;
            ltbResult.Visible   = IsEnabledResult;

            Height = baseHeight_;

            if (IsEnabledArgument == false)
            {
                Height -= 20;

                lblResult.Location = lblArgument.Location;
                ltbResult.Location = ltbArgument.Location;
            }

            if (IsEnabledResult == false)
            {
                Height -= 20;
            }
        }
    }
}
