﻿using System.Diagnostics;
using App.Data;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit
{
    public partial class FileInformationPage : ObjectPropertyPage
    {
        public FileInformationPage() :
            base(PropertyPageID.FileInformation)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_property_window_common_page_a_file_infomation;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new FileInformationPage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            Debug.Assert(TargetDocument is IntermediateFileDocument);

            var doc = TargetDocument as IntermediateFileDocument;

            lblFullPath.IsModified = doc.IsFilePathModified();
            ltbFullPath.Text		= doc.FilePath;
            Project.RelativeType relative;
            ltbProjectPath.Text		= doc.GetProjectPath(out relative);
            ltbProjectPathBase.Text = UIText.EnumValue(relative);
            ltbSearchPath.Text	= doc.BaseName ?? doc.BasePath ?? string.Empty;

            UpdateFileInfo(doc.file_info);
        }

        public static bool IsModified(IntermediateFileDocument activeTarget)
        {
            return activeTarget != null &&
                (activeTarget.IsFilePathModified() ||
                activeTarget.IsFileInfoCreateToolnameModified() ||
                activeTarget.IsFileInfoCreateToolversionModified() ||
                activeTarget.IsFileInfoCreateSrcpathModified() ||
                //
                activeTarget.IsFileInfoModifyToolnameModified() ||
                activeTarget.IsFileInfoModifyToolversionModified());
        }

        private void UpdateFileInfo(file_infoType fileInfo)
        {
            if (fileInfo == null)
            {
                ltbCreateTool.Text		= string.Empty;
                ltbCreateSrc.Text = string.Empty;

                ltbModifyTool.Text		= string.Empty;
            }
            else
            {
                if (fileInfo.create == null)
                {
                    ltbCreateTool.Text		= string.Empty;
                    ltbCreateSrc.Text = string.Empty;
                }
                else
                {
                    ltbCreateTool.Text		= fileInfo.create.tool_name + "    ver " + fileInfo.create.tool_version;
                    ltbCreateSrc.Text = fileInfo.create.src_path;
                }

                if (fileInfo.modify == null)
                {
                    ltbModifyTool.Text		= string.Empty;
                }
                else
                {
                    ltbModifyTool.Text		= fileInfo.modify.tool_name + "    ver " + fileInfo.modify.tool_version;
                }
            }

            var doc = TargetDocument;
            //
            if (doc != null)
            {
                lblCreateTool.IsModified = doc.IsFileInfoCreateToolnameModified() || doc.IsFileInfoCreateToolversionModified();
                lblCreateSrc.IsModified = doc.IsFileInfoCreateSrcpathModified();
                //
                lblModifyTool.IsModified = doc.IsFileInfoModifyToolnameModified() || doc.IsFileInfoModifyToolversionModified();
            }
        }

        private IntermediateFileDocument TargetDocument
        {
            get
            {
                return
                    ((Targets?.Active is Material) && (Targets.Active?.OwnerDocument is SeparateMaterial)) ?
                    (SeparateMaterial)Targets.Active.OwnerDocument : (Targets.Active as IntermediateFileDocument);
            }
        }
    }
}
