﻿using App.Data;
using App.res;
using System;

namespace App.PropertyEdit
{
    public partial class ShapeGeneralPage : ShapePropertyPage
    {
        public ShapeGeneralPage() :
            base(PropertyPageID.ShapeGeneral)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_shape_property_window_general_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new ShapeGeneralPage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            lblBone.IsModified = ActiveTarget.IsValueChanged(x => x.shape_info.bone_name);
            ltbBone.Text		= ActiveTarget.Data.shape_info.bone_name;
            lblOriginalBone.IsModified = ActiveTarget.IsValueChanged(x => x.shape_info.original_bone_name);
            ltbOriginalBone.Text = ActiveTarget.Data.shape_info.original_bone_name;
            lblMaterial.IsModified = ActiveTarget.IsValueChanged(x => x.shape_info.mat_name);
            ltbMaterial.Text = ActiveTarget.Data.shape_info.mat_name;
            lblOriginalMaterial.IsModified = ActiveTarget.IsValueChanged(x => x.shape_info.original_material_name);
            ltbOriginalMaterial.Text = ActiveTarget.Data.shape_info.original_material_name;
            lblSkinning.IsModified = ActiveTarget.IsValueChanged(x => Math.Min(x.shape_info.vertex_skinning_count, 2));
            int skinningCount = ActiveTarget.Data.shape_info.vertex_skinning_count;
            ltbSkinning.Text	=
                (skinningCount == 0) ? Strings.Skinning_RididBody :
                (skinningCount == 1) ? Strings.Skinning_RididSkinning :
                                       string.Format(Strings.Skinning_SmoothSkinning, skinningCount);

            lblDeleteNearVertexMode.IsModified = ActiveTarget.IsValueChanged(x => x.shape_info.delete_near_vertex_mode);
            ltbDeleteNearVertexMode.Text = ActiveTarget.Data.shape_info.delete_near_vertex_mode;
            lblDivideSubmeshMode.IsModified = ActiveTarget.IsValueChanged(x => x.shape_info.divide_submesh_mode);
            ltbDivideSubmeshMode.Text = ActiveTarget.Data.shape_info.divide_submesh_mode;
            //lblBinarizeAdjacency.IsModified = ActiveTarget.IsValueChanged(x => x.shape_info.binarize_adjacency);
            //ltbBinarizeAdjacency.Text		= UIText.FlagYesNo(ActiveTarget.Data.shape_info.binarize_adjacency);
            lblOptimizePrimitiveMode.IsModified = ActiveTarget.IsValueChanged(x => x.shape_info.optimize_primitive_mode);
            ltbOptimizePrimitiveMode.Text	= ActiveTarget.Data.shape_info.optimize_primitive_mode;

            lblOriginalShapeHash.IsModified = ActiveTarget.IsValueChanged(x => x.shape_info.original_shape_hash);
            ltbOriginalShapeHash.Text = ActiveTarget.Data.shape_info.original_shape_hash;
            lblOriginalShapeCount.IsModified = ActiveTarget.IsValueChanged(x => x.shape_info.original_shape_count);
            ltbOriginalShapeCount.Text = ActiveTarget.Data.shape_info.original_shape_count.ToString();
            // 処理頂点数関連項目は、選択プラットフォーム毎に数値が変化することがあるで、変更フラグの対象外とする。
            // lblProcessVertexCount.IsModified = ActiveTarget.savedProcessVertexCountInMesh0 != ActiveTarget.ProcessVertexCountInMesh[0];
            ltbProcessVertexCount.Text = Shape.IsProcessVertexCountComputable() ? ActiveTarget.ProcessVertexCountInMesh[0].ToString() : Strings.ProcessVertexCount_UnsupportedPlatform;
            lblVertexCount.IsModified = ActiveTarget.savedVertexCountInMesh0 != ActiveTarget.VertexCountInMesh[0];
            ltbVertexCount.Text			= ActiveTarget.VertexCountInMesh[0].ToString();
            lblPolygonCount.IsModified = ActiveTarget.IsValueChanged(x => Shape.PolygonCountInMesh(x.mesh_array.mesh[0]));
            ltbPolygonCount.Text = Shape.PolygonCountInMesh(ActiveTarget.Data.mesh_array.mesh[0]).ToString();

            lblPrimitive.IsModified = ActiveTarget.IsValueChanged(x => x.mesh_array.mesh[0].mode);
            ltbPrimitive.Text		= UIText.EnumValue(ActiveTarget.Data.mesh_array.mesh[0].mode);
            lblIndex.IsModified = ActiveTarget.IsValueChanged(x => x.mesh_array.mesh[0].count);
            ltbIndex.Text = ActiveTarget.Data.mesh_array.mesh[0].count.ToString();

            lblIndexQuantize.IsModified = ActiveTarget.IsValueChanged(x => x.mesh_array.mesh[0].quantize_type);
            ltbIndexQuantize.Text	= UIText.EnumValue(ActiveTarget.Data.mesh_array.mesh[0].quantize_type);
        }

        public static bool IsModified(Shape activeTarget)
        {
            return activeTarget != null &&
                (activeTarget.IsValueChanged(x => x.shape_info.bone_name) ||
                activeTarget.IsValueChanged(x => x.shape_info.original_bone_name) ||
                activeTarget.IsValueChanged(x => x.shape_info.mat_name) ||
                activeTarget.IsValueChanged(x => x.shape_info.original_material_name) ||
                activeTarget.IsValueChanged(x => Math.Min(x.shape_info.vertex_skinning_count, 2)) ||
                activeTarget.IsValueChanged(x => x.shape_info.delete_near_vertex_mode) ||
                activeTarget.IsValueChanged(x => x.shape_info.divide_submesh_mode) ||
                activeTarget.IsValueChanged(x => x.shape_info.optimize_primitive_mode) ||
                activeTarget.IsValueChanged(x => x.shape_info.original_shape_hash) ||
                activeTarget.IsValueChanged(x => x.shape_info.original_shape_count) ||
                // 処理頂点数関連項目は、選択プラットフォーム毎に数値が変化することがあるで、変更フラグの対象外とする。
                // ActiveTarget.savedProcessVertexCountInMesh0 != ActiveTarget.ProcessVertexCountInMesh[0] ||
                activeTarget.savedVertexCountInMesh0 != activeTarget.VertexCountInMesh[0] ||
                activeTarget.IsValueChanged(x => Shape.PolygonCountInMesh(x.mesh_array.mesh[0])) ||
                activeTarget.IsValueChanged(x => x.mesh_array.mesh[0].mode) ||
                activeTarget.IsValueChanged(x => x.mesh_array.mesh[0].count) ||
                activeTarget.IsValueChanged(x => x.mesh_array.mesh[0].quantize_type));
        }
    }
}
