﻿using App.Command;
using App.Data;

namespace App.PropertyEdit
{
    public partial class ModelRootPage : ModelPropertyPage
    {
        public ModelRootPage() :
            base(PropertyPageID.ModelRoot)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_model_property_window;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new ModelRootPage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            ;
        }

        #region コピー＆ペースト
        private class CopyData
        {
 			public object ModelGeneralPage{ get; set; }
 			public object ModelPreviewPage{ get; set; }
 			public object UserDataPage{ get; set; }
            public object ModelSearchPathPage { get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return ModelPreviewPage.CanCopy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(Model target)
        {
            return
                new CopyData()
                {
                    ModelGeneralPage = ModelGeneralPage.Copy(target),
                    ModelPreviewPage = ModelPreviewPage.Copy(target),
                    UserDataPage = UserDataPage.Copy(target),
                    ModelSearchPathPage = SearchPathPage.Copy(target),
                };
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            var commandSet = new EditCommandSet();
            {
                var copyData = (CopyData)pasteObject;

                commandSet.Add(ModelGeneralPage.Paste(targets, copyData.ModelGeneralPage));
                commandSet.Add(ModelPreviewPage.Paste(targets, copyData.ModelPreviewPage));
                commandSet.Add(SearchPathPage.Paste(targets, copyData.ModelSearchPathPage));
                commandSet.Add(UserDataPage.Paste(targets, copyData.UserDataPage));
            }

            commandSet.Reverse();
            return commandSet;
        }

        public override bool CanPaste(object copiedObjectInfo, object copiedObject)
        {
            return ModelPreviewPage.CanPaste(Targets, copiedObjectInfo, copiedObject);
        }
        #endregion
    }
}
