﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Windows.Forms;
using App.Command;
using App.ConfigData;
using App.Controls;
using App.Data;
using App.res;
using App.Utility;
using ConfigCommon;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit
{
    public partial class ModelPreviewPage : ModelPropertyPage
    {
        // スケール連動フラグ
        private bool _linkScale = true;
        private static bool _lastLinkScale = true;

        public ModelPreviewPage() :
            base(PropertyPageID.ModelPreview)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_model_property_window_preview_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new ModelPreviewPage();
        }

        AppConfig.ModelPreviewPage config;
        protected override void InitializeFormInternal()
        {
            fepScaleX.Tag		= SrtEditTarget.ScaleX;
            fepScaleY.Tag		= SrtEditTarget.ScaleY;
            fepScaleZ.Tag		= SrtEditTarget.ScaleZ;
            fepRotateX.Tag		= SrtEditTarget.RotateX;
            fepRotateY.Tag		= SrtEditTarget.RotateY;
            fepRotateZ.Tag		= SrtEditTarget.RotateZ;
            fepTranslateX.Tag	= SrtEditTarget.TranslateX;
            fepTranslateY.Tag	= SrtEditTarget.TranslateY;
            fepTranslateZ.Tag	= SrtEditTarget.TranslateZ;

            config = ConfigData.ApplicationConfig.Setting.PropertyEdit.ModelPreviewPage;
            fepScaleX.Maximum = config.ScaleXMax;
            fepScaleX.Minimum = -config.ScaleXMax;
            fepScaleX.UpdateIncrement();
            fepScaleY.Maximum = config.ScaleYMax;
            fepScaleY.Minimum = -config.ScaleYMax;
            fepScaleY.UpdateIncrement();
            fepScaleZ.Maximum = config.ScaleZMax;
            fepScaleZ.Minimum = -config.ScaleZMax;
            fepScaleZ.UpdateIncrement();
            fepRotateX.Maximum = config.RotateXMax;
            fepRotateX.Minimum = -config.RotateXMax;
            fepRotateX.UpdateIncrement();
            fepRotateY.Maximum = config.RotateYMax;
            fepRotateY.Minimum = -config.RotateYMax;
            fepRotateY.UpdateIncrement();
            fepRotateZ.Maximum = config.RotateZMax;
            fepRotateZ.Minimum = -config.RotateZMax;
            fepRotateZ.UpdateIncrement();
            fepTranslateX.Maximum = config.TranslateXMax;
            fepTranslateX.Minimum = -config.TranslateXMax;
            fepTranslateX.UpdateIncrement();
            fepTranslateY.Maximum = config.TranslateYMax;
            fepTranslateY.Minimum = -config.TranslateYMax;
            fepTranslateY.UpdateIncrement();
            fepTranslateZ.Maximum = config.TranslateZMax;
            fepTranslateZ.Minimum = -config.TranslateZMax;
            fepTranslateZ.UpdateIncrement();
            _linkScale = _lastLinkScale;

        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {

            var info = ActiveTarget.PreviewInfo;

            // スケール連動
            chkLinkScale.Checked = _linkScale;

            // コンボボックスアイテムの更新
            {
                using(var block = new UpdateBlock(cmbModel))
                {
                    cmbModel.Items.Clear();
                    var modelsAndChildren = Model.SortByPreviewDepth(Targets.GetObjects(GuiObjectID.Model).Cast<Model>(), true);

                    foreach(var model in DocumentManager.Models.Where(x => x != ActiveTarget && !modelsAndChildren.Contains(x)).OrderBy(x => x.Name))
                    {
                        cmbModel.AddItem(model.Name, model.Name);
                    }

                    cmbModel.AddItem(res.Strings.Model_Preview_NotSelect, null);
                }

                using(var block = new UpdateBlock(cmbBone))
                {
                    cmbBone.Items.Clear();

                    var model = DocumentManager.Models.FirstOrDefault(x => x.Name == info.BindModelName);
                    if (model != null)
                    {
                        var bones = ApplicationConfig.Setting.PropertyEdit.ModelPreviewPage.SortByBoneId
                            ? model.Bones.ToArray()
                            : model.Bones.OrderBy(x => x.Name).ToArray();
                        foreach (var bone in bones)
                        {
                            cmbBone.AddItem(bone.Name, bone.Name);
                        }
                    }

                    cmbBone.AddItem(res.Strings.Model_Preview_NotSelect, null);
                }

                // LOD level
                using (var block = new UpdateBlock(cmbLOD))
                {
                    cmbLOD.Items.Clear();
                    // 「選択しない」を追加
                    cmbLOD.AddItem(res.Strings.Model_Preview_NotSelect, -1);

                    var model = ActiveTarget;
                    if (model != null)
                    {
                        var itemCount = model.Shapes.Any() ? model.Shapes.Max(x => x.VertexCountInMesh.Length): 0;
                        //lvwLod.SetItemCount(itemCount);
                        for (int level = 0; level < itemCount; level++)
                        {
                            int polygonCount = 0;
                            int vertexCount = 0;
                            int processVertexCount = 0;
                            foreach (var shape in ActiveTarget.Shapes)
                            {
                                if (level < shape.VertexCountInMesh.Length)
                                {
                                    polygonCount += shape.PolygonCountInMesh(level);
                                    vertexCount += shape.VertexCountInMesh[level];
                                    processVertexCount += shape.ProcessVertexCountInMesh[level];
                                }
                            }

                            float processVertexCountPerTriangle = polygonCount != 0 ? (float)processVertexCount / polygonCount : 0f;

                            var str = string.Format("{0} (Poly: {1}, Vtx:{2})", level, polygonCount, vertexCount);
                            cmbLOD.AddItem(str, level);
                        }
                    }
                }

                // bone sort
                cmbBoneSort.Items.Clear();
                cmbBoneSort.AddItem(Strings.ModelPreviewPage_UpdateFormInternal_OrderByName, false);
                cmbBoneSort.AddItem(Strings.ModelPreviewPage_UpdateFormInternal_OrderByIndex, true);
            }

            // SendAttach したものはプレビューを無効に
            gbxPlacement.Enabled = Viewer.Manager.Instance.IsConnected && !ActiveTarget.IsSendAttached;
            lblLOD.Enabled = cmbLOD.Enabled = chkDisableVtxQuantize.Enabled
                = Viewer.Manager.Instance.IsConnected;

           // cbxPreviewEnabled.Checked	= info.IsPreviewEnabled;

            lblModel.IsModified = ActiveTarget.IsPreviewInfoValueChanged(x => x.BindModelName);
            cmbModel.SelectedItemData	= info.BindModelName;
            lblBone.IsModified = ActiveTarget.IsPreviewInfoValueChanged(x => x.BindBoneName);
            cmbBone.SelectedItemData	= info.BindBoneName;
            lblScaleX.IsModified = ActiveTarget.IsPreviewInfoValueChanged(x => x.Scale.X);
            fepScaleX.Value				= info.Scale.X;
            lblScaleY.IsModified = ActiveTarget.IsPreviewInfoValueChanged(x => x.Scale.Y);
            fepScaleY.Value				= info.Scale.Y;
            lblScaleZ.IsModified = ActiveTarget.IsPreviewInfoValueChanged(x => x.Scale.Z);
            fepScaleZ.Value				= info.Scale.Z;
            lblRotateX.IsModified = ActiveTarget.IsPreviewInfoValueChanged(x => x.Rotate.X);
            fepRotateX.Value			= info.Rotate.X;
            lblRotateY.IsModified = ActiveTarget.IsPreviewInfoValueChanged(x => x.Rotate.Y);
            fepRotateY.Value			= info.Rotate.Y;
            lblRotateZ.IsModified = ActiveTarget.IsPreviewInfoValueChanged(x => x.Rotate.Z);
            fepRotateZ.Value			= info.Rotate.Z;
            lblTranslateX.IsModified = ActiveTarget.IsPreviewInfoValueChanged(x => x.Translate.X);
            fepTranslateX.Value			= info.Translate.X;
            lblTranslateY.IsModified = ActiveTarget.IsPreviewInfoValueChanged(x => x.Translate.Y);
            fepTranslateY.Value			= info.Translate.Y;
            lblTranslateZ.IsModified = ActiveTarget.IsPreviewInfoValueChanged(x => x.Translate.Z);
            fepTranslateZ.Value			= info.Translate.Z;

            chkDisableVtxQuantize.Checked = ActiveTarget.DisableVertexQuantize;

            cmbLOD.SelectedItemData = ActiveTarget.PreviewLodLevel;

            cmbBoneSort.SelectedIndex = ApplicationConfig.Setting.PropertyEdit.ModelPreviewPage.SortByBoneId ? 1 : 0;
        }

        public static bool IsModified(Model activeTarget)
        {
            return activeTarget != null &&
                (activeTarget.IsPreviewInfoValueChanged(x => x.BindModelName) ||
                activeTarget.IsPreviewInfoValueChanged(x => x.BindBoneName) ||
                activeTarget.IsPreviewInfoValueChanged(x => x.Scale.X) ||
                activeTarget.IsPreviewInfoValueChanged(x => x.Scale.Y) ||
                activeTarget.IsPreviewInfoValueChanged(x => x.Scale.Z) ||
                activeTarget.IsPreviewInfoValueChanged(x => x.Rotate.X) ||
                activeTarget.IsPreviewInfoValueChanged(x => x.Rotate.Y) ||
                activeTarget.IsPreviewInfoValueChanged(x => x.Rotate.Z) ||
                activeTarget.IsPreviewInfoValueChanged(x => x.Translate.X) ||
                activeTarget.IsPreviewInfoValueChanged(x => x.Translate.Y) ||
                activeTarget.IsPreviewInfoValueChanged(x => x.Translate.Z));
        }

        #region コピー＆ペースト
        private class CopyData
        {
            //
            public string		BindModelName		{ get; set; }
            public string		BindBoneName		{ get; set; }
            //
            public Data.Vector4	Scale				{ get; set; }
            public Data.Vector4	Rotate				{ get; set; }
            public Data.Vector4	Translate			{ get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return CanCopy(ActiveTarget);
        }

        public static bool CanCopy(Model ActiveTarget)
        {
            return Viewer.Manager.Instance.IsConnected && !ActiveTarget.IsSendAttached;
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(Model target)
        {
            return
                new CopyData()
                {
                    BindModelName		= target.PreviewInfo.BindModelName,
                    BindBoneName		= target.PreviewInfo.BindBoneName,
                    Scale				= target.PreviewInfo.Scale,
                    Rotate				= target.PreviewInfo.Rotate,
                    Translate			= target.PreviewInfo.Translate
                };
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            var commandSet = new EditCommandSet();
            {
                var copyData = (CopyData)pasteObject;

                //commandSet.Add(CreateEditCommand_OptimizeShader(targets, copyData.OptimizeShader));
                commandSet.Add(CreateEditCommand_Bind(targets, copyData.BindModelName, copyData.BindBoneName));
                commandSet.Add(CreateEditCommand_Scale(targets, copyData.Scale, true));
                commandSet.Add(CreateEditCommand_Rotate(targets, copyData.Rotate, true));
                commandSet.Add(CreateEditCommand_Translate(targets, copyData.Translate, true));
            }
            return commandSet.Execute();
        }

        public override bool CanPaste(object copiedObjectInfo, object copiedObject)
        {
            return CanPaste(Targets, copiedObjectInfo, copiedObject);
        }

        public static bool CanPaste(GuiObjectGroup targets, object copiedObjectInfo, object copiedObject)
        {
            return Viewer.Manager.Instance.IsConnected && targets.Objects.OfType<Model>().All(x => !x.IsSendAttached);
        }
        #endregion

        private static NintendoWare.G3d.Edit.Math.Vector3 Convert(Data.Vector4 src, bool toRadian)
        {
            return
                new NintendoWare.G3d.Edit.Math.Vector3()
                {
                    X = toRadian ? MathUtility.ToRadian(src.X) : src.X,
                    Y = toRadian ? MathUtility.ToRadian(src.Y) : src.Y,
                    Z = toRadian ? MathUtility.ToRadian(src.Z) : src.Z
                };
        }

        private static void EditModelLayout(Model basemodel)
        {
            // このモデルのボーンにバインドしているモデル（小モデル）も送信する
            var models = Model.GetPreviewChildren(basemodel);
            foreach (var model in models)
            {
                EditModelLayout(
                    model,
                    model.PreviewInfo.IsBind,
                    model.PreviewInfo.Scale,
                    model.PreviewInfo.Rotate,
                    model.PreviewInfo.Translate,
                    false
                );
            }
        }

        private static void EditModelLayout(Model model, bool isBind, Data.Vector4 scale, Data.Vector4 rotate, Data.Vector4 translate, bool afterModelLoad)
        {
            Viewer.EditModelLayout.Send(
                model,
                isBind,
                Convert(scale,     false),
                Convert(rotate,    true),
                Convert(translate, false),
                afterModelLoad,
                sendIdentity:true
            );
        }

        private static GroupEditCommand CreateEditCommand_Scale(GuiObjectGroup targets, Data.Vector4 scale, bool isSendToHio)
        {
            var models = targets.GetObjects(GuiObjectID.Model).OfType<Model>().Where(x => !x.IsSendAttached).ToArray();
            var scales = models.Select(x => scale).ToArray();
            return
                new GeneralGroupValueEditCommand<int>(
                    new GuiObjectGroup(DocumentManager.ProjectDocument),
                    GuiObjectID.Project,
                    0,
                    delegate(ref GuiObject target, ref object data, ref object swap)
                    {
                        for (int i = 0; i < models.Length; i++)
                        {
                            var model = models[i];
                            var tmp = model.PreviewInfo.Scale;
                            model.PreviewInfo.Scale = scales[i];
                            scales[i] = tmp;

                            if (isSendToHio)
                            {
                                EditModelLayout(model);
                            }
                        }
                    }
                );
        }

        private static GroupEditCommand CreateEditCommand_Rotate(GuiObjectGroup targets, Data.Vector4 rotate, bool isSendToHio)
        {
            var models = targets.GetObjects(GuiObjectID.Model).OfType<Model>().Where(x => !x.IsSendAttached).ToArray();
            var rotates = models.Select(x => rotate).ToArray();
            return
                new GeneralGroupValueEditCommand<int>(
                    new GuiObjectGroup(DocumentManager.ProjectDocument),
                    GuiObjectID.Project,
                    0,
                    delegate(ref GuiObject target, ref object data, ref object swap)
                    {
                        for (int i = 0; i < models.Length; i++)
                        {
                            var model = models[i];
                            var tmp = model.PreviewInfo.Rotate;
                            model.PreviewInfo.Rotate = rotates[i];
                            rotates[i] = tmp;

                            if (isSendToHio)
                            {
                                EditModelLayout(model);
                            }
                        }
                    }
                );
        }


        private static GroupEditCommand CreateEditCommand_Translate(GuiObjectGroup targets, Data.Vector4 translate, bool isSendToHio)
        {
            var models = targets.GetObjects(GuiObjectID.Model).OfType<Model>().Where(x => !x.IsSendAttached).ToArray();
            var translates = models.Select(x => translate).ToArray();
            return
                new GeneralGroupValueEditCommand<Data.Vector4>(
                    new GuiObjectGroup(DocumentManager.ProjectDocument),
                    GuiObjectID.Project,
                    translate,
                    delegate(ref GuiObject target, ref object data, ref object swap)
                    {
                        for (int i = 0; i < models.Length; i++)
                        {
                            var model = models[i];
                            var tmp = model.PreviewInfo.Translate;
                            model.PreviewInfo.Translate = translates[i];
                            translates[i] = tmp;

                            if (isSendToHio)
                            {
                                EditModelLayout(model);
                            }
                        }
                    }
                );
        }

        private static GroupEditCommand CreateEditCommand_Bind(GuiObjectGroup targets, string modelName, string boneName)
        {
            var models = targets.GetObjects(GuiObjectID.Model).OfType<Model>().Where(x => !x.IsSendAttached).ToArray();
            var names = models.Select(x => new { modelName, boneName }).ToArray();
            return new GeneralGroupValueEditCommand<int>(
                new GuiObjectGroup(DocumentManager.ProjectDocument),
                GuiObjectID.Project,
                0,
                delegate(ref GuiObject target, ref object data, ref object swap)
                {
                    for (int i = 0; i < models.Length; i++)
                    {
                        var model = models[i];
                        var old = new { modelName = model.PreviewInfo.BindModelName, boneName = model.PreviewInfo.BindBoneName };
                        model.PreviewInfo.BindModelName = names[i].modelName;
                        model.PreviewInfo.BindBoneName = names[i].boneName;
                        names[i] = old;

                        {
                            var targetModel =
                                (model.PreviewInfo.BindModelName == null) ?
                                    null :
                                    DocumentManager.Models.FirstOrDefault(x => x.Name == model.PreviewInfo.BindModelName);

                            int boneIndex = -1;
                            {
                                if (targetModel != null)
                                {
                                    var bone =
                                        (model.PreviewInfo.BindBoneName == null) ?
                                            null :
                                            targetModel.Bones.FirstOrDefault(x => x.Name == model.PreviewInfo.BindBoneName);

                                    boneIndex =
                                        (bone == null) ?
                                            -1 :
                                            targetModel.Bones.IndexOf(bone);
                                }
                            }

                            Viewer.EditBoneBind.Send(model, targetModel, boneIndex);
                            EditModelLayout(model);
                        }
                    }
                });
        }

        static private GroupEditCommand CreateEditCommand_DisableVtxQuantize(GuiObjectGroup targets, bool quantize)
        {
            var models = targets.GetObjects(GuiObjectID.Model).OfType<Model>().ToArray();
            var quantizes = models.Select(x => quantize).ToArray();
            return
                new GeneralGroupValueEditCommand<int>(
                    new GuiObjectGroup(DocumentManager.ProjectDocument),
                    GuiObjectID.Project,
                    0,
                    delegate(ref GuiObject target, ref object data, ref object swap)
                    {
                        for (int i = 0; i < models.Length; i++)
                        {
                            var model = models[i];
                            var tmp = model.DisableVertexQuantize;
                            model.DisableVertexQuantize = quantizes[i];
                            quantizes[i] = tmp;
                            Viewer.LoadOrReloadModel.Send(model);
                        }
                    }
                );
        }

        static private GroupEditCommand CreateEditCommand_ChangeLOD(GuiObjectGroup targets, int level)
        {
            var models = targets.Objects.OfType<Model>().ToArray();
            var levels = models.Select(x => level).ToArray();
            return
                new GeneralGroupValueEditCommand<int>(
                    new GuiObjectGroup(DocumentManager.ProjectDocument),
                    GuiObjectID.Project,
                    0,
                    delegate(ref GuiObject target, ref object data, ref object swap)
                    {
                        for (var i = 0; i < models.Length; i++)
                        {
                            var model = models[i];
                            var tmp = model.PreviewLodLevel;

                            var itemCount = model.Shapes.Any() ? model.Shapes.Max(x => x.VertexCountInMesh.Length): 0;

                            if (levels[i] >= 0 && levels[i] < itemCount)
                            {
                                Viewer.EditSetShapeLodLevel.Send(model, levels[i]);
                            }
                            else if (levels[i] == -1)
                            {
                                Viewer.EditResetShapeLodLevel.Send(model);
                            }
                            else
                            {
                                continue;
                            }

                            model.PreviewLodLevel = levels[i];
                            levels[i] = tmp;
                        }
                    }
                );
        }

        private enum SrtEditTarget
        {
            ScaleX,		ScaleY,		ScaleZ,
            RotateX,	RotateY,	RotateZ,
            TranslateX,	TranslateY,	TranslateZ,
        }

        /// <summary>
        /// スケールを揃えている最中か？
        /// </summary>
        private void SrtSequentialValueChanged(object sender, SequentialValueChangedEventArgs e)
        {
            Debug.Assert(sender is FloatEditPanel);
            var control = sender as FloatEditPanel;

            if(e.Changing)
            {
                var scale     = ObjectUtility.Clone(ActiveTarget.PreviewInfo.Scale);
                var rotate    = ObjectUtility.Clone(ActiveTarget.PreviewInfo.Rotate);
                var translate = ObjectUtility.Clone(ActiveTarget.PreviewInfo.Translate);

                if (_linkScale)
                {
                    switch ((SrtEditTarget)control.Tag)
                    {
                        case SrtEditTarget.ScaleX:
                        case SrtEditTarget.ScaleY:
                        case SrtEditTarget.ScaleZ:
                            scale.X = scale.Y = scale.Z = control.Value;
                            using (UIControlEventSuppressBlock block = new UIControlEventSuppressBlock())
                            {
                                fepScaleX.Value = fepScaleY.Value = fepScaleZ.Value = control.Value;
                            }
                            break;
                    }
                }

                switch((SrtEditTarget)control.Tag)
                {
                    case SrtEditTarget.ScaleX:		scale.X		= control.Value;	break;
                    case SrtEditTarget.ScaleY:		scale.Y		= control.Value;	break;
                    case SrtEditTarget.ScaleZ:		scale.Z		= control.Value;	break;
                    case SrtEditTarget.RotateX:		rotate.X	= control.Value;	break;
                    case SrtEditTarget.RotateY:		rotate.Y	= control.Value;	break;
                    case SrtEditTarget.RotateZ:		rotate.Z	= control.Value;	break;
                    case SrtEditTarget.TranslateX:	translate.X	= control.Value;	break;
                    case SrtEditTarget.TranslateY:	translate.Y	= control.Value;	break;
                    case SrtEditTarget.TranslateZ:	translate.Z	= control.Value;	break;
                }

                EditModelLayout(
                    ActiveTarget,
                    ActiveTarget.PreviewInfo.IsBind,
                    scale,
                    rotate,
                    translate,
                    false
                );
            }
            else
            {
                switch((SrtEditTarget)control.Tag)
                {
                    case SrtEditTarget.ScaleX:
                    {
                        var	scale = ActiveTarget.PreviewInfo.Scale;
                        scale.X = control.Value;
                        if (_linkScale)
                        {
                            scale.Y = scale.X;
                            scale.Z = scale.X;
                        }

                        TheApp.CommandManager.Execute(CreateEditCommand_Scale(Targets, scale, true));

                        break;
                    }

                    case SrtEditTarget.ScaleY:
                    {
                        var	scale = ActiveTarget.PreviewInfo.Scale;
                        scale.Y = control.Value;
                        if (_linkScale)
                        {
                            scale.Z = scale.Y;
                            scale.X = scale.Y;
                        }

                        TheApp.CommandManager.Execute(CreateEditCommand_Scale(Targets, scale, true));

                        break;
                    }

                    case SrtEditTarget.ScaleZ:
                    {
                        var	scale = ActiveTarget.PreviewInfo.Scale;
                        scale.Z = control.Value;
                        if (_linkScale)
                        {
                            scale.X = scale.Z;	scale.Y = scale.Z;
                        }

                        TheApp.CommandManager.Execute(CreateEditCommand_Scale(Targets, scale, true));

                        break;
                    }

                    case SrtEditTarget.RotateX:
                    {
                        var	rotate = ActiveTarget.PreviewInfo.Rotate;
                        rotate.X = control.Value;

                        TheApp.CommandManager.Execute(CreateEditCommand_Rotate(Targets, rotate, true));
                        break;
                    }

                    case SrtEditTarget.RotateY:
                    {
                        var	rotate = ActiveTarget.PreviewInfo.Rotate;
                        rotate.Y = control.Value;

                        TheApp.CommandManager.Execute(CreateEditCommand_Rotate(Targets, rotate, true));
                        break;
                    }

                    case SrtEditTarget.RotateZ:
                    {
                        var	rotate = ActiveTarget.PreviewInfo.Rotate;
                        rotate.Z = control.Value;

                        TheApp.CommandManager.Execute(CreateEditCommand_Rotate(Targets, rotate, true));
                        break;
                    }

                    case SrtEditTarget.TranslateX:
                    {
                        var	translate = ActiveTarget.PreviewInfo.Translate;
                        translate.X = control.Value;

                        TheApp.CommandManager.Execute(CreateEditCommand_Translate(Targets, translate, true));
                        break;
                    }

                    case SrtEditTarget.TranslateY:
                    {
                        var	translate = ActiveTarget.PreviewInfo.Translate;
                        translate.Y = control.Value;

                        TheApp.CommandManager.Execute(CreateEditCommand_Translate(Targets, translate, true));
                        break;
                    }

                    case SrtEditTarget.TranslateZ:
                    {
                        var	translate = ActiveTarget.PreviewInfo.Translate;
                        translate.Z = control.Value;

                        TheApp.CommandManager.Execute(CreateEditCommand_Translate(Targets, translate, true));
                        break;
                    }
                }
            }
        }

        private void chkLinkScale_CheckedChanged(object sender, EventArgs e)
        {
            _lastLinkScale = _linkScale = chkLinkScale.Checked;
        }

        private void cmiResetAll_Click(object sender, EventArgs e)
        {
            var commandSet = new EditCommandSet();
            {
                commandSet.Add(CreateEditCommand_Scale(    Targets, new Data.Vector4(1.0f, 1.0f, 1.0f), true));
                commandSet.Add(CreateEditCommand_Rotate(   Targets, new Data.Vector4(0.0f, 0.0f, 0.0f), true));
                commandSet.Add(CreateEditCommand_Translate(Targets, new Data.Vector4(0.0f, 0.0f, 0.0f), true));
            }
            TheApp.CommandManager.Execute(commandSet);
        }

        private void cmiResetScale_Click(object sender, EventArgs e)
        {
            TheApp.CommandManager.Execute(CreateEditCommand_Scale(Targets, new Data.Vector4(1.0f, 1.0f, 1.0f), true));
        }

        private void cmiResetRotate_Click(object sender, EventArgs e)
        {
            TheApp.CommandManager.Execute(CreateEditCommand_Rotate(Targets, new Data.Vector4(0.0f, 0.0f, 0.0f), true));
        }

        private void cmiResetTranslate_Click(object sender, EventArgs e)
        {
            TheApp.CommandManager.Execute(CreateEditCommand_Translate(Targets, new Data.Vector4(0.0f, 0.0f, 0.0f), true));
        }

        private void cmbModel_SelectedIndexChanged(object sender, EventArgs e)
        {
            var commandSet = new EditCommandSet();
            {
                commandSet.Add(CreateEditCommand_Bind(Targets, cmbModel.SelectedItemData as string, null));
            }
            TheApp.CommandManager.Execute(commandSet);
        }

        private void cmbBone_SelectedIndexChanged(object sender, EventArgs e)
        {
            TheApp.CommandManager.Execute(CreateEditCommand_Bind(Targets, cmbModel.SelectedItemData as string, cmbBone.SelectedItemData as string));
        }

        private void chkDisableVtxQuantize_CheckedChanged(object sender, EventArgs e)
        {
            TheApp.CommandManager.Execute(CreateEditCommand_DisableVtxQuantize(Targets, chkDisableVtxQuantize.Checked));
        }

        private void fepScaleX_SliderSettingChanged(object sender, EventArgs e)
        {
            config.ScaleXMax = fepScaleX.Maximum;
        }

        private void fepScaleY_SliderSettingChanged(object sender, EventArgs e)
        {
            config.ScaleYMax = fepScaleY.Maximum;
        }

        private void fepScaleZ_SliderSettingChanged(object sender, EventArgs e)
        {
            config.ScaleZMax = fepScaleZ.Maximum;
        }

        private void fepRotateX_SliderSettingChanged(object sender, EventArgs e)
        {
            config.RotateXMax = fepRotateX.Maximum;
        }

        private void fepRotateY_SliderSettingChanged(object sender, EventArgs e)
        {
            config.RotateYMax = fepRotateY.Maximum;
        }

        private void fepRotateZ_SliderSettingChanged(object sender, EventArgs e)
        {
            config.RotateZMax = fepRotateZ.Maximum;
        }

        private void fepTranslateX_SliderSettingChanged(object sender, EventArgs e)
        {
            config.TranslateXMax = fepTranslateX.Maximum;
        }

        private void fepTranslateY_SliderSettingChanged(object sender, EventArgs e)
        {
            config.TranslateYMax = fepTranslateY.Maximum;
        }

        private void fepTranslateZ_SliderSettingChanged(object sender, EventArgs e)
        {
            config.TranslateZMax = fepTranslateZ.Maximum;
        }

        private void cmbLOD_SelectedIndexChanged(object sender, EventArgs e)
        {
            var selectedIndex = (cmbLOD.SelectedItemData is int) ? (int) cmbLOD.SelectedItemData : -1;
            var models = Targets.Objects.OfType<Model>();
            if (models.All(x => x.PreviewLodLevel == selectedIndex))
            {
                return;
            }
            TheApp.CommandManager.Execute(CreateEditCommand_ChangeLOD(Targets, selectedIndex));
        }

        private void cmbBoneSort_SelectionChangeCommitted(object sender, EventArgs e)
        {
            ConfigData.ApplicationConfig.Setting.PropertyEdit.ModelPreviewPage.SortByBoneId = (cmbBoneSort.SelectedIndex == 1);
            App.AppContext.ExecutePropertyChangedEvent(ActiveTarget, (new DocumentPropertyChangedEventArgs()).GetArgs());
        }

    }
}
