﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Windows.Forms;
using App.Command;
using App.Controls;
using App.Data;
using App.Utility;
using ConfigCommon;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit
{
    public partial class MaterialAnimationOriginalInfoPage : MaterialAnimationPropertyPage
    {
        public MaterialAnimationOriginalInfoPage() :
            base(PropertyPageID.MaterialAnimationGeneral)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window_original_information_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new MaterialAnimationOriginalInfoPage();
        }

        protected override void InitializeFormInternal()
        {
            // Textは書き換わるので退避する
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            var animArray = ActiveTarget.Data.original_per_material_anim_array;
            if (!ActiveTarget.IsExistOriginalAnim() || animArray == null)
            {
                lvwOrgAnim.SetItemCount(0);
                return;
            }


            using (var ub = new UpdateBlock(lvwOrgAnim))
            {
                var animCount =
                    animArray.original_per_material_anim.Select(
                        x => ((x.original_color_anim_array == null)? 0: x.original_color_anim_array.original_color_anim.Select(c => c.original_color_anim_target.Count()).Sum())
                           + ((x.original_texsrt_anim_array == null)? 0 : x.original_texsrt_anim_array.original_texsrt_anim.Select(t => t.original_texsrt_anim_target.Count()).Sum())
                    ).Sum();
                lvwOrgAnim.SetItemCount(animCount);
                int index = 0;
                foreach (var mtl in animArray.original_per_material_anim)
                {
                    if (mtl.original_color_anim_array != null)
                    {
                        foreach (var anim in mtl.original_color_anim_array.original_color_anim)
                        {
                            foreach (var target in anim.original_color_anim_target)
                            {
                                ListViewItem item = lvwOrgAnim.Items[index];
                                //item.Tag = target;
                                // material
                                item.SubItems[clhOrigAnimMtl.Index].Text = mtl.mat_name;

                                // hint
                                item.SubItems[clhOrigAnimHint.Index].Text = anim.hint;

                                // target
                                item.SubItems[clhOrigAnimTarget.Index].Text = target.target.ToString();

                                // value
                                item.SubItems[clhOrigAnimBaseValue.Index].Text = target.base_value.ToString();

                                // numkeys
                                var numKeys = target.Curve == null ? 0 : target.Curve.count;
                                item.SubItems[clhOrigAnimNumKeys.Index].Text = numKeys.ToString();

                                index++;
                            }
                        }
                    }

                    if (mtl.original_texsrt_anim_array != null)
                    {
                        foreach (var anim in mtl.original_texsrt_anim_array.original_texsrt_anim)
                        {
                            foreach (var target in anim.original_texsrt_anim_target)
                            {
                                ListViewItem item = lvwOrgAnim.Items[index];
                                //item.Tag = target;
                                // material
                                item.SubItems[clhOrigAnimMtl.Index].Text = mtl.mat_name;

                                // hint
                                item.SubItems[clhOrigAnimHint.Index].Text = anim.hint;

                                // target
                                item.SubItems[clhOrigAnimTarget.Index].Text = target.target.ToString();

                                // value
                                item.SubItems[clhOrigAnimBaseValue.Index].Text = target.base_value.ToString();

                                // numkeys
                                var numKeys = target.Curve == null ? 0 : target.Curve.count;
                                item.SubItems[clhOrigAnimNumKeys.Index].Text = numKeys.ToString();

                                index++;
                            }
                        }
                    }
                }
            }
        }

        public static bool IsModified(MaterialAnimation target)
        {
            return false;
        }

        #region コマンド
        #endregion

        #region コピー＆ペースト
        #endregion

        #region イベント
        #endregion
    }
}
