﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using App.Controls;
using App.Data;
using App.res;
using App.Utility;
using System.Text.RegularExpressions;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit.ShaderParamControls
{
    public class ChoiceHelper
    {
        public Dictionary<string, LabelHelper> LabelHelpers = new Dictionary<string, LabelHelper>();
        public Dictionary<string, string> labels = new Dictionary<string, string>();
        public bool SetLabel(
            Dictionary<string, string> aliases,
            CustomUI customUI,
            Definition.ShadingModelTable table,
            Predicate<string> visibleGroups,
            HashSet<string> visiblePages,
            bool showId,
            bool showOriginalLabel)
        {
            bool updated = false;
            foreach (var alias in LabelHelpers.Keys.ToArray())
            {
                if (!aliases.ContainsKey(alias))
                {
                    LabelHelpers.Remove(alias);
                    labels.Remove(alias);
                    updated = true;
                }
            }

            foreach (var alias in aliases)
            {
                LabelHelper helper;
                if (!LabelHelpers.TryGetValue(alias.Key, out helper))
                {
                    helper = new LabelHelper();
                    LabelHelpers[alias.Key] = helper;
                }

                bool updated2 = helper.SetLabel(
                    alias.Key,
                    alias.Value,
                    null,
                    customUI,
                    table,
                    visibleGroups,
                    visiblePages,
                    showId,
                    showOriginalLabel);

                if (updated2)
                {
                    labels[alias.Key] = helper.GetLabelString(false);
                    updated = true;
                }
            }

            return updated;
        }
    }
}
