﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using App.Data;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit
{
    public class FogAnimationCurveTreeNodeInfo : IAnimationCurve
    {
        public bool IsEditable { get; set; }
        public AnimationDocument.NonEditableKind NonEditableKind { get; set; }
        public object NonEditableKindDisplayAux { get; set; }
        public bool IsColorCurve
        {
            get
            {
                switch (targetType_)
                {
                    case nw.g3d.nw4f_3dif.fog_anim_target_targetType.color_r:
                    case nw.g3d.nw4f_3dif.fog_anim_target_targetType.color_g:
                    case nw.g3d.nw4f_3dif.fog_anim_target_targetType.color_b:
                        return true;
                    default:
                        return false;
                }
            }
        }

        public int ColorComponentIndex
        {
            get
            {
                switch (targetType_)
                {
                    case nw.g3d.nw4f_3dif.fog_anim_target_targetType.color_r:
                        return 0;
                    case nw.g3d.nw4f_3dif.fog_anim_target_targetType.color_g:
                        return 1;
                    case nw.g3d.nw4f_3dif.fog_anim_target_targetType.color_b:
                        return 2;
                    default:
                        return -1;
                }
            }
        }

        public AnimTarget GetAnimTarget(GuiObject editTarget)
        {
            Debug.Assert(editTarget is FogAnimation);
            var animation = (FogAnimation)editTarget;
            return animation.GetTarget(targetType_);
        }

        public void UpdateIsModified(GuiObject editTarget)
        {
            var animation = (FogAnimation)editTarget;
            var animTarget = GetAnimTarget(animation);
            var savedTarget = animation.savedFogAnimTargets.FirstOrDefault(x => x.targetType == targetType_);
            animation.UpdateIsModifiedAnimTarget(
                (FogAnimationTarget)animTarget,
                savedTarget);
        }

        public AnimTarget CreateAnimTarget(GuiObject editTarget)
        {
            Debug.Assert(false);
            return null;
        }

        public AnimTarget CreateTemporaryTarget(GuiObject editTarget)
        {
            var source = (FogAnimationTarget)GetAnimTarget(editTarget);
            return new FogAnimationTarget()
            {
                targetType = source.targetType,
            };
        }

        public void SetAnimTarget(GuiObject editTarget, AnimTarget animTarget)
        {
            var anims = ((FogAnimation)editTarget).FogAnimTargets;
            var index = anims.FindIndex(x => x.targetType == targetType_);
            Debug.Assert(index >= 0);
            anims[index] = (FogAnimationTarget)animTarget;
        }

        public float GetDefaultValue(GuiObject editTarget)
        {
            return GetAnimTarget(editTarget).GetBaseValue();
        }

        public void IntermediateFileIndices(FogAnimation target, out int cameraIndex, out int curveIndex, out int curveComponentIndex)
        {
            curveComponentIndex = (int)targetType_;
            cameraIndex = target.Owner.FogAnims.IndexOf(target);
            curveIndex = 0;
            foreach (var animTarget in target.FogAnimTargets.Where(x => x.ExportType == CurveExportType.Constant || x.ExportType == CurveExportType.Curve))
            {
                if (animTarget.targetType == targetType_)
                {
                    return;
                }

                curveIndex++;
            }

            curveIndex = -1;
        }

        private readonly FogAnimation	target_;
        private readonly fog_anim_target_targetType targetType_;

        public FogAnimationCurveTreeNodeInfo(FogAnimation target, fog_anim_target_targetType targetType)
        {
            //Debug.Assert(this is IHasAnimTarget);
            target_			= target;
            targetType_	= targetType;
        }

        public List<KeyFrame> KeyFrames
        {
            get
            {
                return
                    (paramAnim != null) ?
                        paramAnim.KeyFrames :
                        new List<KeyFrame>();
            }
        }

        public FogAnimationTarget paramAnim { get { return target_.GetTarget(targetType_); } }
        public InterpolationType CurveInterpolationType
        {
            get
            {
                return paramAnim != null ? paramAnim.CurveInterpolationType : InterpolationType.Linear;
            }

            set
            {
                ;   // 無視
            }
        }

        public string ParentName{		get { return string.Empty;		} }
        public string Name{				get { return string.Empty;		} }
        public string FullPath
        {
            get
            {
                switch(targetType_)
                {
                    case fog_anim_target_targetType.dist_attn_start:	return target_.Name + " / dist_attn / start";
                    case fog_anim_target_targetType.dist_attn_end:		return target_.Name + " / dist_attn / end";
                    case fog_anim_target_targetType.color_r:			return target_.Name + " / color / R";
                    case fog_anim_target_targetType.color_g:			return target_.Name + " / color / G";
                    case fog_anim_target_targetType.color_b:			return target_.Name + " / color / B";
                }

                Debug.Assert(false);
                return string.Empty;
            }
        }

        public int ComponentIndex{		get { return (int)targetType_;	} }
        public bool IsRotate
        {
            get {
                return false;
            }
        }
        public float? MinClampValue{	get { return MinFitValue;	} }
        public float? MaxClampValue{	get { return MaxFitValue;	} }
        public float? MinFitValue{
            get {
                switch (paramAnim.targetType)
                {
                    case fog_anim_target_targetType.color_r:
                    case fog_anim_target_targetType.color_g:
                    case fog_anim_target_targetType.color_b:
                        return 0;
                }
                return null;
            }
        }
        public float? MaxFitValue{
            get {
                switch (paramAnim.targetType)
                {
                    case fog_anim_target_targetType.color_r:
                    case fog_anim_target_targetType.color_g:
                    case fog_anim_target_targetType.color_b:
                        return 1;
                }
                return null;
            }
        }
        public PrimitiveTypeKind CurvePrimitiveType { get { return PrimitiveTypeKind.Float; } }
        public Color CurveColor
        {
            get
            {
                switch (paramAnim.targetType)
                {
                    case fog_anim_target_targetType.color_r: return CurveView.MakeRGBAColorFromIndex(0);
                    case fog_anim_target_targetType.color_g: return CurveView.MakeRGBAColorFromIndex(1);
                    case fog_anim_target_targetType.color_b: return CurveView.MakeRGBAColorFromIndex(2);
                }

                return CurveView.MakeColorFromString(FullPath);
            }
        }


        public bool IsSame(IAnimationCurve curve)
        {
            var fogCurve = (FogAnimationCurveTreeNodeInfo)curve;
            return fogCurve.target_ == target_ &&
                fogCurve.targetType_ == targetType_;
        }
    }
}
