﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace App.Data
{
    public interface IReferTexture
    {
        Dictionary<string, string> ReferenceTexturePaths { get; set; }
    }

    public static class IReferTextureExtension
    {
        public static Texture GetReferenceTexture(this IReferTexture refer, string name)
        {
            Debug.Assert(name != null);

            string path;
            refer.ReferenceTexturePaths.TryGetValue(name, out path);
            return DocumentManager.Textures.FirstOrDefault(tex => tex.Name == name && string.Compare(path, tex.FilePath, true) == 0);
        }
    }
}
