﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace App.Controls
{
    /// <summary>
    /// 値編集同調マーククラス。
    /// </summary>
    [ToolboxItem(true)]
    public sealed class ValueEditBuddyMark : UIControl
    {
        // 三点描画フラグ
        private bool _triangular = false;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ValueEditBuddyMark()
        {
            base.SetStyle(ControlStyles.Selectable, false);
            base.DoubleBuffered = true;
            base.TabStop = false;
        }

        /// <summary>
        /// 三点描画フラグ。
        /// </summary>
        [DefaultValue(false)]
        [Description("三点で描画するかどうかを示します。")]
        public bool Triangular
        {
            get { return _triangular; }
            set
            {
                _triangular = value;
                Invalidate();
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override Size DefaultSize
        {
            get { return new Size(8, 40); }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnPaint(PaintEventArgs e)
        {
            // 背景
            e.Graphics.Clear(BackColor);

            // 描画点
            Rectangle rcClient = ClientRectangle;
            Point[] points = {
                new Point(0,              0),
                new Point(rcClient.Right, 0),
                new Point(rcClient.Right, rcClient.Bottom),
                new Point(0,              rcClient.Bottom),
            };

            // 描画
            Color color = SystemColors.ControlText;
            if (!Enabled)
            {
                color = SystemColors.GrayText;
            }
            using (Pen pen = new Pen(color, 4))
            {
                e.Graphics.DrawLines(pen, points);

                if (_triangular)
                {
                }
            }
            // 三点描画
            if (_triangular)
            {
                Point[] centerPoints = {
                    new Point(0,              rcClient.Bottom / 2),
                    new Point(rcClient.Right, rcClient.Bottom / 2),
                };
                using (Pen pen = new Pen(color, 2))
                {
                    e.Graphics.DrawLines(pen, centerPoints);
                }
            }
        }

        #region デザイナ制御
        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        [DefaultValue(false)]
        public new bool TabStop
        {
            get { return base.TabStop; }
            set { base.TabStop = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public override string Text
        {
            get { return base.Text; }
            set { base.Text = value; }
        }
        #endregion
    }
}
