﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.ComponentModel;
using System.Windows.Forms;

namespace App.Controls
{
    /// <summary>
    /// ＵＩピクチャボックスクラス。
    /// </summary>
    public class UIPictureBox : PictureBox
    {
        // 拡張ボーダースタイル
        private ExtendedBorderStyle _extendedBorderStyle = ExtendedBorderStyle.None;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UIPictureBox()
        {
        }

        //---------------------------------------------------------------------
        // プロパティ
        /// <summary>
        /// 拡張ボーダースタイル。
        /// </summary>
        [DefaultValue(ExtendedBorderStyle.None)]
        [Description(UIControlHelper.PropertyDesc_ExtendedBorderStyle)]
        public ExtendedBorderStyle ExtendedBorderStyle
        {
            get { return _extendedBorderStyle; }
            set
            {
                if (_extendedBorderStyle != value)
                {
                    _extendedBorderStyle = value;
                    base.UpdateStyles();
                }
            }
        }

        #region オーバーライド
        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams cp = base.CreateParams;
                UIControlHelper.SetExtendedBorderStyleCreateParams(cp, _extendedBorderStyle);
                return cp;
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                if (UIControlEventSuppressBlock.Enabled)
                {
                    return false;
                }
                return base.CanRaiseEvents;
            }
        }
        #endregion

        #region デザイナ制御
        /// <summary>
        /// 再定義。
        /// </summary>
        [DefaultValue(false)]
        public new bool TabStop
        {
            // 基本クラスで false に初期化されるが DefaultValue が設定されていないため、
            // デザイナコードで設定コードが入ってしまうのを防ぐ
            get { return base.TabStop;  }
            set { base.TabStop = value; }
        }
        #endregion
    }
}
