﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace App.Controls
{
    /// <summary>
    /// ＵＩパネルクラス。
    /// </summary>
    public class UIPanel : Panel
    {
        // 拡張ボーダースタイル
        private ExtendedBorderStyle _extendedBorderStyle = ExtendedBorderStyle.None;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UIPanel()
        {
        }

        //---------------------------------------------------------------------
        // プロパティ
        /// <summary>
        /// 拡張ボーダースタイル。
        /// </summary>
        [DefaultValue(ExtendedBorderStyle.None)]
        [Category(UIControlHelper.OriginalPropertyCategoryName)]
        [Description(UIControlHelper.PropertyDesc_ExtendedBorderStyle)]
        public ExtendedBorderStyle ExtendedBorderStyle
        {
            get { return _extendedBorderStyle; }
            set
            {
                if (_extendedBorderStyle != value)
                {
                    _extendedBorderStyle = value;
                    base.UpdateStyles();
                }
            }
        }

        /// <summary>
        /// ダブルバッファリングフラグ。
        /// </summary>
        [DefaultValue(false)]
        [Category(UIControlHelper.OriginalPropertyCategoryName)]
        [Description(UIControlHelper.PropertyDesc_DoubleBufferring)]
        public bool DoubleBuffering
        {
            get { return base.DoubleBuffered; }
            set { base.DoubleBuffered = value; }
        }

        #region オーバーライド
        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams cp = base.CreateParams;
                UIControlHelper.SetExtendedBorderStyleCreateParams(cp, _extendedBorderStyle);
                return cp;
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                if (UIControlEventSuppressBlock.Enabled)
                {
                    return false;
                }
                return base.CanRaiseEvents;
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnScroll(ScrollEventArgs e)
        {
            // トラッキング中のスクロール
            ControlUtility.ApplyTrackingAutoScroll(this, e);
            base.OnScroll(e);
        }

        protected override Point ScrollToControl(Control activeControl)
        {
            return DisplayRectangle.Location;
        }
        #endregion
    }

    /// <summary>
    /// スクロールを止められるパネル
    /// </summary>
    public class UIScrollPanel : UIPanel
    {
        public bool StopScroll { get; set; }

        protected override Point ScrollToControl(Control activeControl)
        {
            if (StopScroll)
            {
                return DisplayRectangle.Location;
            }
            else
            {
                return base.ScrollToControl(activeControl);
            }
        }
    }

    /// <summary>
    /// ＵＩフローレイアウトパネルクラス。
    /// </summary>
    public class UIFlowLayoutPanel : FlowLayoutPanel
    {
        // 拡張ボーダースタイル
        private ExtendedBorderStyle _extendedBorderStyle = ExtendedBorderStyle.None;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UIFlowLayoutPanel()
        {
        }

        //---------------------------------------------------------------------
        // プロパティ
        /// <summary>
        /// 拡張ボーダースタイル。
        /// </summary>
        [DefaultValue(ExtendedBorderStyle.None)]
        [Category(UIControlHelper.OriginalPropertyCategoryName)]
        [Description(UIControlHelper.PropertyDesc_ExtendedBorderStyle)]
        public ExtendedBorderStyle ExtendedBorderStyle
        {
            get { return _extendedBorderStyle; }
            set
            {
                if (_extendedBorderStyle != value)
                {
                    _extendedBorderStyle = value;
                    base.UpdateStyles();
                }
            }
        }

        /// <summary>
        /// ダブルバッファリングフラグ。
        /// </summary>
        [DefaultValue(false)]
        [Category(UIControlHelper.OriginalPropertyCategoryName)]
        [Description(UIControlHelper.PropertyDesc_DoubleBufferring)]
        public bool DoubleBuffering
        {
            get { return base.DoubleBuffered; }
            set { base.DoubleBuffered = value; }
        }

        #region オーバーライド
        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams cp = base.CreateParams;
                UIControlHelper.SetExtendedBorderStyleCreateParams(cp, _extendedBorderStyle);
                return cp;
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                if (UIControlEventSuppressBlock.Enabled)
                {
                    return false;
                }
                return base.CanRaiseEvents;
            }
        }
        #endregion
    }

    /// <summary>
    /// ＵＩテーブルレイアウトパネルクラス。
    /// </summary>
    public class UITableLayoutPanel : TableLayoutPanel
    {
        // 拡張ボーダースタイル
        private ExtendedBorderStyle _extendedBorderStyle = ExtendedBorderStyle.None;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UITableLayoutPanel()
        {
        }

        //---------------------------------------------------------------------
        // プロパティ
        /// <summary>
        /// 拡張ボーダースタイル。
        /// </summary>
        [DefaultValue(ExtendedBorderStyle.None)]
        [Category(UIControlHelper.OriginalPropertyCategoryName)]
        [Description(UIControlHelper.PropertyDesc_ExtendedBorderStyle)]
        public ExtendedBorderStyle ExtendedBorderStyle
        {
            get { return _extendedBorderStyle; }
            set
            {
                if (_extendedBorderStyle != value)
                {
                    _extendedBorderStyle = value;
                    base.UpdateStyles();
                }
            }
        }

        /// <summary>
        /// ダブルバッファリングフラグ。
        /// </summary>
        [DefaultValue(false)]
        [Category(UIControlHelper.OriginalPropertyCategoryName)]
        [Description(UIControlHelper.PropertyDesc_DoubleBufferring)]
        public bool DoubleBuffering
        {
            get { return base.DoubleBuffered; }
            set { base.DoubleBuffered = value; }
        }

        #region オーバーライド
        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams cp = base.CreateParams;
                UIControlHelper.SetExtendedBorderStyleCreateParams(cp, _extendedBorderStyle);
                return cp;
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                if (UIControlEventSuppressBlock.Enabled)
                {
                    return false;
                }
                return base.CanRaiseEvents;
            }
        }
        #endregion
    }
}
