﻿using System;
using System.Drawing;
using System.Windows.Forms;
using App.Data;
using App.Utility;

namespace App.Controls
{
    /// <summary>
    /// テクスチャ選択ダイアログクラス。
    /// </summary>
    public sealed partial class TextureSelectDialog : OkCancelDialog
    {
        // テクスチャ選択パネル
        private readonly TextureSelectPanel _panel;
        // サイズ
        private static Size _size = Size.Empty;
        // 選択テクスチャイメージ
        //private Texture _selectedTexImage = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TextureSelectDialog(Texture initialTexture, Predicate<Texture> canSelect)
        {
            InitializeComponent();

            DialogUtility.SetHelp(this, HelpUtility.PageKey.p_animation_property_window_pattern_page_a_tex_pattern_change);

            // 選択パネル作成
            _panel = new TextureSelectPanel();
            _panel.Parent = pnlClient;
            _panel.Dock = DockStyle.Fill;

            // テクスチャ登録
            //foreach (Texture texture in ProjectManager.Textures)
            // ソートしてパネルに追加する。
            foreach (Texture texture in DocumentManager.SortedTextures)
            {
                _panel.AddTextureItem(texture, canSelect(texture));
                if (initialTexture == texture)
                {
                    _panel.SelectedIndex = _panel.TextureItemCount - 1;
                }
            }

            // 初期選択
            Action UpdateBtnOK = () => { btnOK.Enabled = (_panel.SelectedTexture != null); };
            _panel.ComponentUpdated += UpdateBtnOK;
            UpdateBtnOK();

            // ダブルクリックによる選択を決定扱いにする。
            _panel.TextureSelected += delegate { DialogResult = DialogResult.OK; };

            // サイズ設定
            if (_size != Size.Empty) { Size = _size; }
            FormClosed += delegate { _size = Size; };
        }

        public Texture SelectedTex
        {
            get { return _panel.SelectedTexture; }
        }
        /*
        /// <summary>
        /// 選択テクスチャイメージ。
        /// </summary>
        [Browsable(false)]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public Texture SelectedTexImage
        {
            get { return _selectedTexImage; }
        }*/

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool OnResultOk()
        {
            //Texture texture = _panel.SelectedTexture;

            // テクスチャイメージ作成
            //_selectedTexImage = texture;//TexImage.Create(texture, null);
            return true;
        }
    }
}
