﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using App.Data;
using nw.g3d.nw4f_3dif;
using nw.g3d.iflib;
using nw.g3d.iflib.nw3de;
using App.Utility;

namespace App.Controls
{
    public partial class SeparateMaterialCreateDialog : OkCancelDialog
    {
        public string MaterialName { get; private set; } = string.Empty;

        public ShaderDefinition ShaderDefinition { get; private set; } = null;

        public shading_modelType ShadingModel { get; private set; } = null;

        public SeparateMaterialCreateDialog()
        {
            InitializeComponent();
        }

        private void UpdateState()
        {
            btnOK.Enabled =
                !string.IsNullOrEmpty(MaterialName) &&
                (ShaderDefinition != null) &&
                (ShadingModel != null);
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            tbxName.Text = MaterialName;

            cmbShaderDefinition.Items.AddRange(
                DocumentManager.ShaderDefinitions
                .OrderBy(x => x.Name)
                .Where(x =>
                    (x.Data != null) &&
                    (x.Data.shading_model_array != null) &&
                    (x.Data.shading_model_array.shading_model != null) &&
                    x.Data.shading_model_array.shading_model.Any(y => y.IsMaterialShader()))
                .Select(x => new UIListControlItem(x.Name, x)).ToArray());

            if (cmbShaderDefinition.Items.Count > 0)
            {
                cmbShaderDefinition.SelectedIndex = 0;
            }

            if (cmbShadingModel.Items.Count > 0)
            {
                cmbShadingModel.SelectedIndex = 0;
            }

            UpdateState();
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            if (DialogResult == DialogResult.OK)
            {
                // マテリアル中間ファイルのマテリアル名はファイル名。
                // 同名ファイルの作成は許可しない。
                // Windows 環境のファイル名は大文字小文字の区別がない。
                if (DocumentManager.SeparateMaterials.SelectMany(x => x.Materials).Any(x => string.Equals(x.Name, MaterialName, StringComparison.OrdinalIgnoreCase)))
                {
                    UIMessageBox.Error(App.res.Strings.SeparateMaterial_NewFileCreation_AlreadyOpened);
                    e.Cancel = true;
                    return;
                }
            }
            base.OnClosing(e);
        }

        private void tbxName_TextChanged(object sender, EventArgs e)
        {
            // ファイル名として使えない文字が含まれていた場合は、変更前の状態に戻す。
            if (tbxName.Text.IndexOfAny(System.IO.Path.GetInvalidFileNameChars()) != -1)
            {
                tbxName.Text = MaterialName;
            }
            else
            {
                MaterialName = tbxName.Text;
            }
            UpdateState();
        }

        private void cmbShaderDefinition_SelectedIndexChanged(object sender, EventArgs e)
        {
            var item = cmbShaderDefinition.SelectedItem as UIListControlItem;
            ShaderDefinition = (ShaderDefinition)item?.Data;

            cmbShadingModel.Items.Clear();

            var shadingModels = ShaderDefinition?.Data?.shading_model_array?.shading_model;
            if (shadingModels != null)
            {
                cmbShadingModel.Items.AddRange(
                    shadingModels.Where(x => x.IsMaterialShader())
                    .Select(x => new UIListControlItem(x.name, x)).ToArray());
                if (cmbShadingModel.Items.Count > 0)
                {
                    cmbShadingModel.SelectedIndex = 0;
                }
            }

            UpdateState();
        }

        private void cmbShadingModel_SelectedIndexChanged(object sender, EventArgs e)
        {
            var item = cmbShadingModel.SelectedItem as UIListControlItem;
            ShadingModel = (shading_modelType)item?.Data;

            UpdateState();
        }
    }
}
