﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;
using App.Data;

namespace App.Controls
{
    [ToolboxItem(true)]
    public partial class RgbaTable : UIUserControl
    {
        public RgbaTable()
        {
            InitializeComponent();
            values = new[] { false, false, false, false };

            DoubleBuffered = true;
        }

        private readonly bool[] values;
        public bool[] Values
        {
            set
            {
                if (value == null)
                {
                    value = new[] { false, false, false, false };
                }

                Debug.Assert(value.Length == 4);
                for (int i = 0; i < 4; i++)
                {
                    values[i] = value[i];
                }
                Invalidate();
            }
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            using (var pen = new Pen(Enabled ? Color.Black : Color.DarkGray))
            using (var brush = new SolidBrush(Enabled ? Color.Black : Color.Gray))
            {
                int x0 = 0;
                int y0 = 0;
                int w = Width;
                int h = Height;
                e.Graphics.DrawRectangle(pen, x0, y0, w - 1, h - 1);
                e.Graphics.DrawLine(pen, x0, y0 + h / 2, x0 + w, y0 + h / 2);
                for (int i = 1; i < 4; i++)
                {
                    e.Graphics.DrawLine(pen, x0 + i * w / 4, y0, x0 + i * w / 4, y0 + h);
                }
                string[] title = { "R", "G", "B", "A" };
                Color[] enabledColors = { Color.Red, Color.Green, Color.Blue, Color.Black};
                Color[] disabledColors = { Color.Gray, Color.Gray, Color.Gray, Color.Gray};
                Color[] colors = Enabled ? enabledColors : disabledColors;

                for (int i = 0; i < 4; i++)
                {
                    var size = e.Graphics.MeasureString(title[i], TheApp.GuiFont);
                    float x = x0 + ((2 * i + 1) * w)/ 8.0f;
                    float y = y0 + h / 4.0f;
                    using (var colorBrush = new SolidBrush(colors[i]))
                    {
                        e.Graphics.DrawString(title[i], TheApp.GuiFont, colorBrush, x - size.Width / 2, y - size.Height / 2);
                    }

                    if (Enabled)
                    {
                        var value = UIText.FlagYesNo(values[i]);
                        y = y0 + 3 * h / 4.0f;
                        size = e.Graphics.MeasureString(value, TheApp.GuiFont);
                        e.Graphics.DrawString(value, TheApp.GuiFont, brush, x - size.Width / 2, y - size.Height / 2);
                    }
                }
            }
            //base.OnPaint(e);
        }
    }
}
