﻿using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using App.Data;
using App.Properties;
using App.Utility;
using nw.g3d.iflib;

namespace App.Controls
{
    public sealed partial class BoneVisibilityAnimationMergeDialog : OkCancelDialog
    {
        private readonly BoneVisibilityAnimation dstBoneVisibilityAnimation_;
        private readonly BoneVisibilityAnimation srcBoneVisibilityAnimation_;

        public IEnumerable<IfMergeSrcDstPair> BoneNamePairTable		{ get{ return mtsBone.NameTables;		} }

        public bool IsSame { get { return mtsBone.IsSame; } }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public BoneVisibilityAnimationMergeDialog(BoneVisibilityAnimation dstBoneVisibilityAnimation, BoneVisibilityAnimation srcBoneVisibilityAnimation)
        {
            dstBoneVisibilityAnimation_ = dstBoneVisibilityAnimation;
            srcBoneVisibilityAnimation_ = srcBoneVisibilityAnimation;

            InitializeComponent();

            DialogUtility.SetHelp(this, HelpUtility.PageKey.p_file_menu_a_mergedialog);

            tbxDstPath.Text = dstBoneVisibilityAnimation_.FilePath;
            tbxSrcPath.Text = srcBoneVisibilityAnimation_.FilePath;

            // ボーン
            {
                mtsBone.OrgSrcNames = srcBoneVisibilityAnimation.BoneVisibilityBoneAnims.Select(x => x.bone_name).ToArray();
                mtsBone.OrgDstNames = dstBoneVisibilityAnimation.BoneVisibilityBoneAnims.Select(x => x.bone_name).ToArray();
                mtsBone.TargetImage = Resources.GuiObject_Bone;
                mtsBone.NameTablesChange += (s, e) => lblBoneResultCount0.Text = mtsBone.NameTablesLength.ToString();
                mtsBone.Initialize();
                lblBoneResultCount1.Text = mtsBone.OrgDstNames.Length.ToString();
            }
        }

        private void pctSrcTarget_Paint(object sender, PaintEventArgs e)
        {
            DrawTarget(e.Graphics, srcBoneVisibilityAnimation_.Name, pctSrcTarget.ClientRectangle);
        }

        private void pctDstTarget_Paint(object sender, PaintEventArgs e)
        {
            DrawTarget(e.Graphics, dstBoneVisibilityAnimation_.Name, pctDstTarget.ClientRectangle);
        }

        private void DrawTarget(Graphics g, string name, Rectangle bounds)
        {
            // 背景
            g.Clear(BackColor);

            // アイコン
            Rectangle rcIcon = bounds;
            rcIcon.X += 2;
            rcIcon.Y += (bounds.Height - 16) / 2;
            rcIcon.Size = new Size(16, 16);
            g.DrawImage(Resources.GuiObject_BoneVisibilityAnimation, rcIcon);

            // テキスト
            Rectangle rcText = bounds;
            RectangleUtility.OffsetLeft(ref rcText, rcIcon.Width + 2);
            using (StringFormat sf = new StringFormat())
            {
                sf.Alignment     = StringAlignment.Near;
                sf.LineAlignment = StringAlignment.Center;
                sf.Trimming      = StringTrimming.EllipsisCharacter;
                sf.FormatFlags  |= StringFormatFlags.NoWrap;

                g.DrawString(name, Font, SystemBrushes.WindowText, rcText, sf);
            }
        }
    }
}
