﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.ComponentModel;
using System.Text;
using System.Windows.Forms;

namespace App.Controls
{
    public partial class FileErrorDialog : OkDialog
    {
        public FileErrorDialog(Tuple<string, string, string>[] items)
        {
            InitializeComponent();
            uiListView1.BeginUpdate();
            foreach (var item in items)
            {
                uiListView1.Items.Add(new ListViewItem(new string[] { item.Item1, item.Item2, item.Item3 }));
            }
            uiListView1.EndUpdate();
        }

        private void CopyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            StringBuilder builder = new StringBuilder();
            foreach (ListViewItem item in uiListView1.Items)
            {
                if (item.Selected)
                {
                    bool firstItem = true;
                    foreach (ListViewItem.ListViewSubItem subItem in item.SubItems)
                    {
                        if (!firstItem)
                        {
                            builder.Append('\t');
                        }
                        builder.Append(subItem.Text);
                        firstItem = false;
                    }
                    builder.Append("\r\n");
                }
            }

            App.Utility.ClipboardUtility.SetDataObject(builder.ToString());
        }

        private void SelectToolStripMenuItem_Click(object sender, EventArgs e)
        {
            foreach (ListViewItem item in uiListView1.Items)
            {
                item.Selected = true;
            }
        }

        private void contextMenuStrip1_Opening(object sender, CancelEventArgs e)
        {
            CopyToolStripMenuItem.Enabled = uiListView1.SelectedIndices.Count > 0;
        }
    }
}
