﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace App.Controls
{
    public partial class PresetTextureDialog : OkCancelDialog
    {
        /// <summary>
        /// Tag に設定するデータ
        /// </summary>
        public class TagData
        {
            public TeamConfig.Preset.TexturePreset TexturePreset;

            public TagData(TeamConfig.Preset.TexturePreset texturePreset)
            {
                TexturePreset = texturePreset;
            }
        }

        const int CB_SETCUEBANNER = 0x1703;

        private List<Func<bool>> acceptable = new List<Func<bool>>();

        public PresetTextureDialog()
        {
            InitializeComponent();

            cbxTextureFormat.Items.AddRange(Enum.GetValues(typeof(nw.g3d.nw4f_3dif.texture_info_quantize_typeType)).Cast<nw.g3d.nw4f_3dif.texture_info_quantize_typeType>().Select(x => new UIListControlItem(App.Data.UIText.EnumValue(x), x)).ToArray());
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            // 入力必須項目に設定。
            if (cbxTextureFormat.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.MandatoryField);
                Win32.NativeMethods.SendMessage(cbxTextureFormat.Handle, CB_SETCUEBANNER, IntPtr.Zero, ptr);
                acceptable.Add(() => { return cbxTextureFormat.SelectedItem != null; });
            }

            var data = (TagData)Tag;
            tbxTextureName.Text = data.TexturePreset.Name;
            cbxTextureFormat.SelectedItem = cbxTextureFormat.Items.Cast<UIListControlItem>().FirstOrDefault(x => (nw.g3d.nw4f_3dif.texture_info_quantize_typeType)x.Data == data.TexturePreset.quantize_type);
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            base.OnClosing(e);

            // e.Cancel 操作は base.OnClosing() 後に行う必要がある。
            if ((DialogResult == DialogResult.OK) && !acceptable.All(x => x()))
            {
                e.Cancel = true;
            }
        }

        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // 変更を適用。
            if (DialogResult == DialogResult.OK)
            {
                // null 文字から空文字への変更を回避。
                Func<string, string, string> CorrectString = (oldValue, newValue) =>
                {
                    return ((oldValue == null) && string.IsNullOrEmpty(newValue)) ? null : newValue;
                };

                var data = (TagData)Tag;
                data.TexturePreset.Name = CorrectString(data.TexturePreset.Name, tbxTextureName.Text);
                if (cbxTextureFormat.SelectedItem != null)
                {
                    data.TexturePreset.quantize_type = (nw.g3d.nw4f_3dif.texture_info_quantize_typeType)((UIListControlItem)cbxTextureFormat.SelectedItem).Data;
                }
            }
        }
    }
}
