﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using App.Controls;

namespace App.Controls
{
    partial class AnimationSettingPopupBase : UIUserControl
    {
        public static bool AutoScale = false;

        public virtual bool IsEditing() { return false; }

        protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
        {
            // 既定の処理
            if (base.ProcessCmdKey(ref msg, keyData))
            {
                return true;
            }
            // メインフレームのショートカット処理
            return TheApp.MainFrame.ProcessCommandKey(ref msg, keyData);
        }

        // アニメーション圧縮率文字列を作る
        public static string MakeAnimationCompressRatioString(float src)
        {
            string s = string.Format("{0:f2}", src * 100.0f);

            if (s.EndsWith(".00"))
            {
                s = s.Substring(0, s.Length - 3);
            }
            else
                if (s.EndsWith("0"))
                {
                    s = s.Substring(0, s.Length - 1);
                }

            return string.Format("({0}%)", s);
        }

        // アニメーション圧縮率文字列を作る
        public static string MakeAnimationCompressRatioString(int beforeDataSize, int afterDataSize)
        {
            float src = (float)beforeDataSize / (float)afterDataSize;

            string s = string.Format("{0:f2}", src * 100.0f);

            if (s.EndsWith(".00"))
            {
                s = s.Substring(0, s.Length - 3);
            }
            else
                if (s.EndsWith("0"))
                {
                    s = s.Substring(0, s.Length - 1);
                }

            return string.Format("({0}% {1}/{2})", s, beforeDataSize, afterDataSize);
        }

        protected enum QuantizationResultRow
        {
            Scale,
            Rotate,
            Translate,
            Total,
        }

        protected enum QuantizationResultColumn
        {
            Name,
            UncompressDataSize,
            CompressDataSize,
            ReductionRate,
        }

        protected void SetQuantizationResult(UIListView listView, QuantizationResultRow row, QuantizationResultColumn column, string text)
        {
            listView.Items[(int)row].SubItems[(int)column].Text = text;
        }

        protected void SetQuantizationResult(UIListView listView, QuantizationResultRow row, int uncompressDataSize, int compressDataSize)
        {
            SetQuantizationResult(listView, row, QuantizationResultColumn.UncompressDataSize, uncompressDataSize.ToString());
            SetQuantizationResult(listView, row, QuantizationResultColumn.CompressDataSize, compressDataSize.ToString());

            if (uncompressDataSize > 0)
            {
                float reductionRate = (float)compressDataSize / uncompressDataSize;
                reductionRate = (1 - reductionRate) * 100;
                SetQuantizationResult(listView, row, QuantizationResultColumn.ReductionRate, reductionRate.ToString("0.00"));
            }
            else
            {
                SetQuantizationResult(listView, row, QuantizationResultColumn.ReductionRate, "");
            }
        }

        // 量子化による削減結果を更新する
        protected void UpdateQuantizationResult(UIListView listView,
                                                int scaleUncompressDataSize, int scaleCompressDataSize,
                                                int rotateUncompressDataSize, int rotateCompressDataSize,
                                                int translateUncompressDataSize, int translateCompressDataSize)
        {
            // スケール・回転・移動
            SetQuantizationResult(listView, QuantizationResultRow.Scale, scaleUncompressDataSize, scaleCompressDataSize);
            SetQuantizationResult(listView, QuantizationResultRow.Rotate, rotateUncompressDataSize, rotateCompressDataSize);
            SetQuantizationResult(listView, QuantizationResultRow.Translate, translateUncompressDataSize, translateCompressDataSize);

            // 全体
            int totalUncompressDataSize = scaleUncompressDataSize;
            totalUncompressDataSize += rotateUncompressDataSize;
            totalUncompressDataSize += translateUncompressDataSize;
            int totalCompressDataSize = scaleCompressDataSize;
            totalCompressDataSize += rotateCompressDataSize;
            totalCompressDataSize += translateCompressDataSize;
            SetQuantizationResult(listView, QuantizationResultRow.Total, totalUncompressDataSize, totalCompressDataSize);
        }
    }
}
