﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Diagnostics;
using namespace System::Collections::Generic;

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/g3d_EditDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class SystemBeginFreezeCommand : public EditCommand
{
public:
    SystemBeginFreezeCommand(TargetEndianKind targetEndian)
     : EditCommand(targetEndian)
    {
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

    virtual property bool IsSystemBeginCommand
    {
        bool get() override
        {
            return true;
        }
    }

protected:
    virtual bool CanProcessImpl() override
    {
        return true;
    }
};

private ref class SystemEndFreezeCommand : public EditCommand
{
public:
    SystemEndFreezeCommand(TargetEndianKind targetEndian)
        : EditCommand(targetEndian)
    {
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

    virtual property bool IsSystemEndCommand
    {
        bool get() override
        {
            return true;
        }
    }

protected:
    virtual bool CanProcessImpl() override
    {
        return true;
    }
};

private ref class SystemBeginFreezeNoSyncCommand : public EditCommand
{
public:
    SystemBeginFreezeNoSyncCommand(TargetEndianKind targetEndian)
        : EditCommand(targetEndian)
    {
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

    virtual property bool IsSystemBeginCommand
    {
        bool get() override
        {
            return true;
        }
    }

protected:
    virtual bool CanProcessImpl() override
    {
        return true;
    }
};

private ref class SystemResetRuntimeStateCommand : public EditCommand
{
public:
    SystemResetRuntimeStateCommand(TargetEndianKind targetEndian)
        : EditCommand(targetEndian)
    {
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

protected:
    virtual bool CanProcessImpl() override
    {
        return true;
    }
};

private ref class SystemEditSelectTargetCommand : public EditIndicesModelCommand
{
public:
    SystemEditSelectTargetCommand(TargetEndianKind targetEndian, IEditModelTarget^ target, SelectTargetKind kind, array<INT32>^ indices)
        : EditIndicesModelCommand(targetEndian, target, indices)
    {
        m_Kind = kind;
    }

    virtual bool MakeCommandPacket() override;

protected:
    virtual bool CanProcessImpl() override
    {
        if (Target->ModelObjKey > 0)
        {
            return true;
        }
        return false;
    }

private:
    SelectTargetKind m_Kind;
};

public ref class SystemRuntimeDebugLogCommand : public EditCommand
{
public:
    SystemRuntimeDebugLogCommand(TargetEndianKind targetEndian, bool isRuntimeDebugLogEnabled)
     : EditCommand(targetEndian)
     , m_IsRuntimeDebugLogEnabled(isRuntimeDebugLogEnabled)
    {
    }

    virtual bool MakeCommandPacket() override;

private:
    bool m_IsRuntimeDebugLogEnabled;
};

}}} // namespace NintendoWare.G3d.Edit
