﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// g3dhiolib.h

#pragma once

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class MaterialCommandMaker abstract sealed
{
public:
    static int CalcEditMaterialSamplerValuePacketSize(array<INT32>^ indices);
    static int CalcEditMaterialVector4ValuePacketSize(array<INT32>^ indices);
    static int CalcEditMaterialShaderParamVectorValuePacketSize(array<INT32>^ indices);
    static int CalcEditMaterialShaderParamMatrixValuePacketSize(array<INT32>^ indices);

    generic<typename ValueType>
    static bool MakeEditMaterialValuePacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::edit::detail::EditTargetKind editTargetKind,
        UINT32 key,
        array<INT32>^ indices,
        ValueType value,
        TargetEndianKind endianKind);

    static bool MakeEditMaterialValueU16Packet(
        array<System::Byte>^ packetBuffer,
        nw::g3d::edit::detail::EditTargetKind editTargetKind,
        UINT32 key,
        array<INT32>^ indices,
        u16 highValue,
        u16 lowValue,
        TargetEndianKind endianKind);

    generic<typename ValueType>
        static bool MakeEditBoneValuePacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::edit::detail::EditTargetKind editTargetKind,
        UINT32 key,
        array<INT32>^ indices,
        ValueType value,
        TargetEndianKind endianKind);

    generic<typename ValueType>
    static bool MakeEditMaterialSamplerValuePacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::edit::detail::EditTargetKind editTargetKind,
        UINT32 key,
        array<INT32>^ indices,
        INT32 samplerIndex,
        ValueType value,
        TargetEndianKind endianKind);

    static bool MakeEditMaterialVector4ValueFloatPacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::edit::detail::EditTargetKind editTargetKind,
        UINT32 key,
        array<INT32>^ indices,
        array<float>^ value,
        TargetEndianKind endianKind);

    generic<typename ValueType>
    static bool MakeEditMaterialShaderParamVectorValuePacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::edit::detail::EditTargetKind editTargetKind,
        UINT32 key,
        System::String^ paramName,
        array<INT32>^ indices,
        array<ValueType>^ value,
        TargetEndianKind endianKind);

    static bool MakeEditMaterialShaderParamMatrixValuePacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::edit::detail::EditTargetKind editTargetKind,
        UINT32 key,
        System::String^ paramName,
        array<INT32>^ indices,
        array<float>^ value,
        TargetEndianKind endianKind);
};

}}} // namespace NintendoWare.G3d.Edit
